/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageElement
implements Queryable,
RootsProvider {
    public static final DataKey<PackageElement> DATA_KEY = DataKey.create((String)"package.element");
    @Nullable
    private final Module myModule;
    @NotNull
    private final PsiPackage myElement;
    private final boolean myIsLibraryElement;

    public PackageElement(@Nullable Module module2, @NotNull PsiPackage element, boolean isLibraryElement) {
        this.myModule = module2;
        this.myElement = element;
        this.myIsLibraryElement = isLibraryElement;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public PsiPackage getPackage() {
        return this.myElement;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        PsiDirectory[] dirs;
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (PsiDirectory each : dirs = PackageUtil.getDirectories(this.getPackage(), this.myModule, this.isLibraryElement())) {
            roots.add(each.getVirtualFile());
        }
        return roots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageElement)) {
            return false;
        }
        PackageElement packageElement = (PackageElement)o;
        if (this.myIsLibraryElement != packageElement.myIsLibraryElement) {
            return false;
        }
        if (!this.myElement.equals(packageElement.myElement)) {
            return false;
        }
        return !(this.myModule != null ? !this.myModule.equals(packageElement.myModule) : packageElement.myModule != null);
    }

    public int hashCode() {
        int result = this.myModule != null ? this.myModule.hashCode() : 0;
        result = 29 * result + this.myElement.hashCode();
        result = 29 * result + (this.myIsLibraryElement ? 1 : 0);
        return result;
    }

    public boolean isLibraryElement() {
        return this.myIsLibraryElement;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        PsiPackage pkg = this.getPackage();
        if (pkg instanceof Queryable) {
            ((Queryable)pkg).putInfo(info);
        }
    }
}

