/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.CreateLibraryFromFilesDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MarkLibraryRootAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        List<VirtualFile> jars = MarkLibraryRootAction.getRoots(e);
        if (jars.isEmpty()) {
            return;
        }
        List<OrderRoot> roots = RootDetectionUtil.detectRoots(jars, null, project2, new DefaultLibraryRootsComponentDescriptor());
        new CreateLibraryFromFilesDialog(project2, roots).show();
    }

    @NotNull
    private static List<VirtualFile> getRoots(AnActionEvent e) {
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null || files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            if (file2.isDirectory()) {
                roots.add(file2);
                continue;
            }
            VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file2);
            if (root == null) continue;
            roots.add(root);
        }
        return roots;
    }

    public void update(AnActionEvent e) {
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)e);
        boolean visible = false;
        if (project2 != null && ModuleManager.getInstance((Project)project2).getModules().length > 0) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            block0: for (VirtualFile root : MarkLibraryRootAction.getRoots(e)) {
                if (!root.isInLocalFileSystem() && FileUtilRt.extensionEquals((String)root.getName(), (String)"jar") && !fileIndex.isInLibraryClasses(root)) {
                    visible = true;
                    break;
                }
                if (!root.isInLocalFileSystem() || !root.isDirectory()) continue;
                for (VirtualFile child : root.getChildren()) {
                    VirtualFile jarRoot;
                    if (!FileUtilRt.extensionEquals((String)child.getName(), (String)"jar") || (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child)) == null || fileIndex.isInLibraryClasses(child)) continue;
                    visible = true;
                    continue block0;
                }
            }
        }
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible);
    }
}

