/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList hosts = ContainerUtil.newArrayList(UpdateSettings.getInstance().getPluginHosts());
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.add(null);
        return hosts;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPluginsFromAllRepositories(@Nullable ProgressIndicator indicator) throws IOException {
        ArrayList<IdeaPluginDescriptor> result = new ArrayList<IdeaPluginDescriptor>();
        HashSet<String> addedPluginIds = new HashSet<String>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            List<IdeaPluginDescriptor> plugins2 = RepositoryHelper.loadPlugins(host, indicator);
            for (IdeaPluginDescriptor plugin : plugins2) {
                if (!addedPluginIds.add(plugin.getPluginId().getIdString())) continue;
                result.add(plugin);
            }
        }
        return result;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(null, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator) throws IOException {
        boolean forceHttps = repositoryUrl == null && IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        return RepositoryHelper.loadPlugins(repositoryUrl, null, null, forceHttps, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber apiVersion, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) throws IOException {
        boolean forceHttps = repositoryUrl == null && IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        return RepositoryHelper.loadPlugins(repositoryUrl, apiVersion, buildNumber, forceHttps, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber apiVersion, @Nullable BuildNumber buildNumber, boolean forceHttps, @Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(repositoryUrl, apiVersion, buildNumber, null, forceHttps, indicator);
    }

    @NotNull
    public static Map<PluginId, List<Pair<String, IdeaPluginDescriptor>>> loadPluginsFromChannels(@Nullable BuildNumber apiVersion, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) throws IOException {
        String url;
        LinkedHashMap result = new LinkedHashMap();
        try {
            URIBuilder uriBuilder = new URIBuilder(ApplicationInfoImpl.getShadowInstance().getChannelsListUrl());
            uriBuilder.addParameter("build", apiVersion != null ? apiVersion.asString() : ApplicationInfoImpl.getShadowInstance().getApiVersion());
            url = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        boolean forceHttps = IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        List channelList = (List)HttpRequests.request((String)url).forceHttps(forceHttps).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<String>>(){

            public List<String> process(@NotNull HttpRequests.Request request) throws IOException {
                return (List)JsonUtil.nextObject(new JsonReaderEx(request.getReader().readLine())).get("channels");
            }
        });
        for (String channel : channelList) {
            List<IdeaPluginDescriptor> channelPlugins = RepositoryHelper.loadPlugins(null, apiVersion, buildNumber, channel, forceHttps, indicator);
            for (IdeaPluginDescriptor plugin : channelPlugins) {
                PluginId pluginId = plugin.getPluginId();
                List pluginChannelDescriptors = (List)result.get(pluginId);
                if (pluginChannelDescriptors == null) {
                    pluginChannelDescriptors = new SmartList();
                    result.put(pluginId, pluginChannelDescriptors);
                }
                pluginChannelDescriptors.add(Pair.create((Object)channel, (Object)plugin));
            }
        }
        return result;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber apiVersion, @Nullable BuildNumber buildNumber, @Nullable String channel, boolean forceHttps, final @Nullable ProgressIndicator indicator) throws IOException {
        String url;
        String host;
        File pluginListFile;
        try {
            URIBuilder uriBuilder;
            if (repositoryUrl == null) {
                uriBuilder = new URIBuilder(ApplicationInfoImpl.getShadowInstance().getPluginsListUrl());
                pluginListFile = new File(PathManager.getPluginsPath(), channel == null ? PLUGIN_LIST_FILE : channel + "_" + PLUGIN_LIST_FILE);
                if (pluginListFile.length() > 0L) {
                    uriBuilder.addParameter("crc32", Files.hash((File)pluginListFile, (HashFunction)Hashing.crc32()).toString());
                }
            } else {
                uriBuilder = new URIBuilder(repositoryUrl);
                pluginListFile = null;
            }
            if (!"file".equals(uriBuilder.getScheme())) {
                uriBuilder.addParameter("build", apiVersion != null ? apiVersion.asString() : ApplicationInfoImpl.getShadowInstance().getApiVersion());
                uriBuilder.addParameter("product-build", buildNumber != null ? buildNumber.asString() : ApplicationInfoImpl.getShadowInstance().getBuild().asString());
                if (channel != null) {
                    uriBuilder.addParameter("channel", channel);
                }
            }
            host = uriBuilder.getHost();
            url = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{host}));
        }
        RequestBuilder request = HttpRequests.request((String)url).forceHttps(forceHttps);
        return RepositoryHelper.process(repositoryUrl, (List)request.connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<IdeaPluginDescriptor>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<IdeaPluginDescriptor> process(@NotNull HttpRequests.Request request) throws IOException {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                URLConnection connection = request.getConnection();
                if (pluginListFile != null && pluginListFile.length() > 0L && connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                    return RepositoryHelper.loadPluginList(pluginListFile);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{host}));
                }
                if (pluginListFile != null) {
                    Class<RepositoryHelper> clazz = RepositoryHelper.class;
                    synchronized (RepositoryHelper.class) {
                        FileUtil.ensureExists((File)pluginListFile.getParentFile());
                        request.saveToFile(pluginListFile, indicator);
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return RepositoryHelper.loadPluginList(pluginListFile);
                    }
                }
                return RepositoryHelper.parsePluginList(request.getReader());
            }
        }));
    }

    @Nullable
    public static List<IdeaPluginDescriptor> loadCachedPlugins() throws IOException {
        File file2 = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        return file2.length() == 0L ? null : RepositoryHelper.loadPluginList(file2);
    }

    private static List<IdeaPluginDescriptor> loadPluginList(@NotNull File file2) throws IOException {
        return RepositoryHelper.parsePluginList(new InputStreamReader((InputStream)new FileInputStream(file2), CharsetToolkit.UTF8_CHARSET));
    }

    private static List<IdeaPluginDescriptor> parsePluginList(@NotNull Reader reader) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            RepositoryContentHandler handler2 = new RepositoryContentHandler();
            parser.parse(new InputSource(reader), (DefaultHandler)handler2);
            List<IdeaPluginDescriptor> list = handler2.getPluginsList();
            return list;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            reader.close();
        }
    }

    private static List<IdeaPluginDescriptor> process(@Nullable String repositoryUrl, List<IdeaPluginDescriptor> list) {
        Iterator<IdeaPluginDescriptor> i = list.iterator();
        while (i.hasNext()) {
            PluginNode node = (PluginNode)i.next();
            if (node.getPluginId() == null || repositoryUrl != null && node.getDownloadUrl() == null) {
                LOG.warn("Malformed plugin record (id:" + node.getPluginId() + " repository:" + repositoryUrl + ")");
                i.remove();
                continue;
            }
            if (repositoryUrl != null) {
                node.setRepositoryName(repositoryUrl);
            }
            if (node.getName() != null) continue;
            String url = node.getDownloadUrl();
            String name = FileUtil.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1));
            node.setName(name);
        }
        return list;
    }
}

