/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginClassCache;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.xmlb.XmlSerializationException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerCore {
    private static final Logger LOG = Logger.getInstance(PluginManagerCore.class);
    private static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    public static final String CORE_PLUGIN_ID = "com.intellij";
    private static final String META_INF = "META-INF";
    public static final String PLUGIN_XML = "plugin.xml";
    private static final float PLUGINS_PROGRESS_MAX_VALUE = 0.3f;
    private static final TObjectIntHashMap<PluginId> ourId2Index = new TObjectIntHashMap();
    static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins = new THashMap();
    private static final PluginClassCache ourPluginClasses = new PluginClassCache();
    private static final String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
    static final String DISABLE = "disable";
    static final String ENABLE = "enable";
    static final String EDIT = "edit";
    private static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    private static List<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static IdeaPluginDescriptor[] ourPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    public static String BUILD_NUMBER;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        return PluginManagerCore.getPlugins(null);
    }

    @NotNull
    public static synchronized IdeaPluginDescriptor[] getPlugins(@Nullable StartupProgress progress) {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(progress);
        }
        return ourPlugins;
    }

    public static synchronized void setPlugins(@NotNull IdeaPluginDescriptor[] descriptors) {
        ourPlugins = descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        File file2 = new File(configPath, DISABLED_PLUGINS_FILENAME);
        List requiredPlugins = StringUtil.split((String)System.getProperty("idea.required.plugins.id", ""), (String)",");
        if (file2.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file2));
                try {
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (requiredPlugins.contains(id = id.trim())) continue;
                        disabledPlugins.add(id);
                    }
                }
                finally {
                    reader.close();
                    if (!requiredPlugins.isEmpty()) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        return ourDisabledPlugins;
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        return PluginManagerCore.getBrokenPluginVersions().get((Object)descriptor.getPluginId().getIdString()).contains(descriptor.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt")));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse((String)s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = (String)tokens.get(0);
                        List versions = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues((Object)pluginId, versions);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream((Closeable)br);
                }
            }
        }
        return ourBrokenPluginVersions;
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    private static boolean isUITestMode() {
        return !StringUtil.isEmpty((String)System.getenv("UI_TEST_MODE"));
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append, @NotNull File plugins2) throws IOException {
        if (!plugins2.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins2);
        }
        PluginManagerCore.writePluginsList(ids, new BufferedWriter(new FileWriter(plugins2, append)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        try {
            for (String id : ids) {
                writer.write(id);
                writer.write(LineSeparator.getSystemLineSeparator().getSeparatorString());
            }
        }
        finally {
            writer.close();
        }
    }

    public static boolean disablePlugin(@NotNull String id) {
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        if (disabledPlugins.contains(id)) {
            return false;
        }
        disabledPlugins.add(id);
        try {
            PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean enablePlugin(@NotNull String id) {
        if (!PluginManagerCore.getDisabledPlugins().contains(id)) {
            return false;
        }
        PluginManagerCore.getDisabledPlugins().remove(id);
        try {
            PluginManagerCore.saveDisabledPlugins(PluginManagerCore.getDisabledPlugins(), false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void saveDisabledPlugins(@NotNull Collection<String> ids, boolean append) throws IOException {
        File plugins2 = new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, append, plugins2);
        ourDisabledPlugins = null;
    }

    public static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static int getPluginLoadingOrder(@NotNull PluginId id) {
        return ourId2Index.get((Object)id);
    }

    static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check) {
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check, (Set<PluginId>)new THashSet());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check, @NotNull Set<PluginId> processed2) {
        processed2.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet optionalDependencies = new THashSet(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed2.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check.value((Object)dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = (IdeaPluginDescriptor)pluginId2Descriptor.fun((Object)dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check, processed2)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(PluginId pluginId) {
        ourPluginClasses.addPluginClass(pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            ClassLoader loader = descriptor.getPluginClassLoader();
            if (!(loader instanceof PluginClassLoader) || !((PluginClassLoader)((Object)loader)).hasLoadedClass(className)) continue;
            return descriptor.getPluginId();
        }
        return null;
    }

    public static void dumpPluginClassStatistics() {
        ourPluginClasses.dumpPluginClassStatistics();
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map, boolean checkModuleDependencies) {
        for (PluginId id : descriptor.getDependentPluginIds()) {
            if (ArrayUtil.contains((Object)id, (Object[])descriptor.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId[] dependentPluginIds;
        for (PluginId dependentPluginId : dependentPluginIds = descriptor.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    public static void configureExtensions() {
        Extensions.setLogProvider((LogProvider)new IdeaLogProvider());
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        Extensions.registerAreaClass((String)"IDEA_MODULE", (String)"IDEA_PROJECT");
    }

    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        return ReflectionUtil.getDeclaredMethod(loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass(), (String)"addURL", (Class[])new Class[]{URL.class});
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor.getUseIdeaClassLoader() || PluginManagerCore.isUITestMode()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file2 = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file2.toURI().toURL());
                }
                return loader;
            }
            catch (IOException e) {
                PluginManagerCore.getLogger().warn((Throwable)e);
            }
            catch (IllegalAccessException e) {
                PluginManagerCore.getLogger().warn((Throwable)e);
            }
            catch (InvocationTargetException e) {
                PluginManagerCore.getLogger().warn((Throwable)e);
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file3 = aClassPath.getCanonicalFile();
                urls.add(file3.toURI().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot);
        }
        catch (MalformedURLException e) {
            PluginManagerCore.getLogger().warn((Throwable)e);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn((Throwable)e);
        }
        return null;
    }

    public static void invalidatePlugins() {
        ourPlugins = null;
        ourDisabledPlugins = null;
    }

    public static boolean isPluginClass(@NotNull String className) {
        return ourPlugins != null && PluginManagerCore.getPluginByClassName(className) != null;
    }

    private static void logPlugins() {
        ArrayList<String> loadedBundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : ourPlugins) {
            String version = descriptor.getVersion();
            String s = descriptor.getName() + (version != null ? " (" + version + ")" : "");
            if (descriptor.isEnabled()) {
                if (descriptor.isBundled() || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) {
                    loadedBundled.add(s);
                    continue;
                }
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        Collections.sort(loadedBundled);
        Collections.sort(loadedCustom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(loadedBundled, (String)", "));
        if (!loadedCustom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(loadedCustom, (String)", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, (String)", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull PluginId[] pluginIds) {
        if (PluginManagerCore.isUnitTestMode()) {
            return new ClassLoader[0];
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            classLoaders.add(loader);
        }
        return classLoaders.toArray(new ClassLoader[classLoaders.size()]);
    }

    private static int countPlugins(@NotNull String pluginsPath) {
        String[] list;
        File configuredPluginsDir = new File(pluginsPath);
        if (configuredPluginsDir.exists() && (list = configuredPluginsDir.list()) != null) {
            return list.length;
        }
        return 0;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (!errors.isEmpty()) {
            String errorMessage = IdeBundle.message((String)"error.problems.found.loading.plugins", (Object[])new Object[0]) + StringUtil.join(errors, (String)"<p/>");
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && !app.isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManagerCore.getLogger().error(errorMessage);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map) {
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map.put(PluginId.getId((String)entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull List<String> errors) {
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        final DFSTBuilder builder = new DFSTBuilder(graph);
        if (!builder.isAcyclic()) {
            String cyclePresentation;
            final ArrayList cycles = new ArrayList();
            builder.getSCCs().forEach(new TIntProcedure(){
                private int myTNumber;

                public boolean execute(int size) {
                    if (size > 1) {
                        String cycle = "";
                        for (int j = 0; j < size; ++j) {
                            PluginId id = (PluginId)builder.getNodeByTNumber(this.myTNumber + j);
                            ((IdeaPluginDescriptor)idToDescriptorMap.get(id)).setEnabled(false);
                            cycle = cycle + id.getIdString() + " ";
                        }
                        cycles.add(cycle);
                    }
                    this.myTNumber += size;
                    return true;
                }
            });
            if (ApplicationManager.getApplication().isInternal()) {
                cyclePresentation = StringUtil.join(cycles, (String)";");
            } else {
                Couple circularDependency = builder.getCircularDependency();
                PluginId id = (PluginId)circularDependency.getFirst();
                PluginId parentId = (PluginId)circularDependency.getSecond();
                cyclePresentation = id + "->" + parentId + "->...->" + id;
            }
            errors.add(IdeBundle.message((String)"error.plugins.should.not.have.cyclic.dependencies", (Object[])new Object[0]) + " " + cyclePresentation);
        }
        final Comparator idComparator = builder.comparator();
        return new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(@NotNull IdeaPluginDescriptor o1, @NotNull IdeaPluginDescriptor o2) {
                PluginId pluginId1 = o1.getPluginId();
                PluginId pluginId2 = o2.getPluginId();
                if (pluginId1.getIdString().equals(PluginManagerCore.CORE_PLUGIN_ID)) {
                    return -1;
                }
                if (pluginId2.getIdString().equals(PluginManagerCore.CORE_PLUGIN_ID)) {
                    return 1;
                }
                return idComparator.compare(pluginId1, pluginId2);
            }
        };
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        Collections.sort(ids, new Comparator<PluginId>(){

            @Override
            public int compare(@NotNull PluginId o1, @NotNull PluginId o2) {
                return o2.getIdString().compareTo(o1.getIdString());
            }
        });
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<PluginId>(){

            public Collection<PluginId> getNodes() {
                return ids;
            }

            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins2 = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor.getDependentPluginIds()) {
                    PluginId realPluginId;
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null || !idToDescriptorMap.containsKey(realPluginId = dep.getPluginId())) continue;
                    plugins2.add(realPluginId);
                }
                return plugins2.iterator();
            }
        }));
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file2, @NotNull String fileName) {
        File descriptorFile = new File(file2, META_INF + File.separator + fileName);
        if (descriptorFile.exists()) {
            try {
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file2);
                descriptor.readExternal(descriptorFile.toURI().toURL());
                return descriptor;
            }
            catch (XmlSerializationException e) {
                PluginManagerCore.getLogger().info("Cannot load " + file2, (Throwable)e);
                PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
            }
            catch (Throwable e) {
                PluginManagerCore.getLogger().info("Cannot load " + file2, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String fileName) {
        try {
            String fileURL = StringUtil.replace((String)file2.toURI().toASCIIString(), (String)"!", (String)"%21");
            URL jarURL = new URL("jar:" + fileURL + "!/" + META_INF + '/' + fileName);
            ZipFile zipFile = new ZipFile(file2);
            try {
                ZipEntry entry = zipFile.getEntry("META-INF/" + fileName);
                if (entry == null) return null;
                Document document = JDOMUtil.loadDocument((InputStream)zipFile.getInputStream(entry));
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file2);
                descriptor.readExternal(document, jarURL);
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
                return ideaPluginDescriptorImpl;
            }
            finally {
                zipFile.close();
            }
        }
        catch (XmlSerializationException e) {
            PluginManagerCore.getLogger().info("Cannot load " + file2, (Throwable)e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
            return null;
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + file2, e);
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(final @NotNull File file2, @NotNull String fileName) {
        IdeaPluginDescriptorImpl descriptor = null;
        final boolean directory = file2.isDirectory();
        if (directory) {
            descriptor = PluginManagerCore.loadDescriptorFromDir(file2, fileName);
            if (descriptor == null) {
                File libDir = new File(file2, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files = libDir.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(@NotNull File o1, @NotNull File o2) {
                        if (o2.getName().startsWith(file2.getName())) {
                            return Integer.MAX_VALUE;
                        }
                        if (o1.getName().startsWith(file2.getName())) {
                            return -2147483647;
                        }
                        if (o2.getName().startsWith("resources")) {
                            return -2147483647;
                        }
                        if (o1.getName().startsWith("resources")) {
                            return Integer.MAX_VALUE;
                        }
                        return 0;
                    }
                });
                for (File f : files) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (FileUtil.isJarOrZip((File)f)) {
                        descriptor = PluginManagerCore.loadDescriptorFromJar(f, fileName);
                        if (descriptor == null) continue;
                        descriptor.setPath(file2);
                        break;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, fileName)) == null) continue;
                    if (descriptor != null) {
                        PluginManagerCore.getLogger().info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor = descriptor1;
                    descriptor.setPath(file2);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)".jar") && file2.exists()) {
            descriptor = PluginManagerCore.loadDescriptorFromJar(file2, fileName);
        }
        if (descriptor != null) {
            PluginManagerCore.resolveOptionalDescriptors(fileName, descriptor, new Function<String, IdeaPluginDescriptorImpl>(){

                public IdeaPluginDescriptorImpl fun(String optionalDescriptorName) {
                    URL resource;
                    IdeaPluginDescriptorImpl optionalDescriptor = PluginManagerCore.loadDescriptor(file2, optionalDescriptorName);
                    if (optionalDescriptor == null && directory && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optionalDescriptorName)) != null) {
                        optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource);
                    }
                    return optionalDescriptor;
                }
            });
        }
        return descriptor;
    }

    public static void resolveOptionalDescriptors(@NotNull String fileName, @NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Function<String, IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        Map<PluginId, String> optionalConfigs = descriptor.getOptionalConfigs();
        if (optionalConfigs != null && !optionalConfigs.isEmpty()) {
            THashMap descriptors = new THashMap(optionalConfigs.size());
            for (Map.Entry<PluginId, String> entry : optionalConfigs.entrySet()) {
                String optionalDescriptorName = entry.getValue();
                if (fileName.equals(optionalDescriptorName)) {
                    PluginManagerCore.getLogger().info("recursive dependency (" + fileName + ") in " + descriptor);
                    continue;
                }
                IdeaPluginDescriptorImpl optionalDescriptor = (IdeaPluginDescriptorImpl)optionalDescriptorLoader.fun((Object)optionalDescriptorName);
                if (optionalDescriptor == null) {
                    PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
                    continue;
                }
                descriptors.put(entry.getKey(), optionalDescriptor);
            }
            descriptor.setOptionalDescriptors((Map<PluginId, IdeaPluginDescriptorImpl>)descriptors);
        }
    }

    public static void loadDescriptors(@NotNull File pluginsHome, @NotNull List<IdeaPluginDescriptorImpl> result, @Nullable StartupProgress progress, int pluginsCount) {
        File[] files = pluginsHome.listFiles();
        if (files != null) {
            int i = result.size();
            for (File file2 : files) {
                int oldIndex;
                IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file2, PLUGIN_XML);
                if (descriptor == null) continue;
                if (progress != null) {
                    progress.showProgress(descriptor.getName(), 0.3f * ((float)(++i) / (float)pluginsCount));
                }
                if ((oldIndex = result.indexOf(descriptor)) >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result.get(oldIndex);
                    if (StringUtil.compareVersionNumbers((String)oldDescriptor.getVersion(), (String)descriptor.getVersion()) >= 0) continue;
                    result.set(oldIndex, descriptor);
                    continue;
                }
                result.add(descriptor);
            }
        }
    }

    private static void filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptor> result, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> errors) {
        THashMap idToDescriptorMap = new THashMap();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it = result.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor = it.next();
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                errors.add(IdeBundle.message((String)"message.duplicate.plugin.id", (Object[])new Object[0]) + id);
                it.remove();
                continue;
            }
            if (!descriptor.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor);
        }
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)idToDescriptorMap);
        SmartList disabledPluginIds = new SmartList();
        LinkedHashSet faultyDescriptors = new LinkedHashSet();
        Iterator<? extends IdeaPluginDescriptor> it2 = result.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, new Function<PluginId, IdeaPluginDescriptor>((Map)idToDescriptorMap){
                final /* synthetic */ Map val$idToDescriptorMap;
                {
                    this.val$idToDescriptorMap = map;
                }

                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return (IdeaPluginDescriptor)this.val$idToDescriptorMap.get(pluginId);
                }
            }, new Condition<PluginId>((Map)idToDescriptorMap, pluginDescriptor, faultyDescriptors, (List)disabledPluginIds, disabledPluginNames, errors, it2){
                final /* synthetic */ Map val$idToDescriptorMap;
                final /* synthetic */ IdeaPluginDescriptor val$pluginDescriptor;
                final /* synthetic */ LinkedHashSet val$faultyDescriptors;
                final /* synthetic */ List val$disabledPluginIds;
                final /* synthetic */ Map val$disabledPluginNames;
                final /* synthetic */ List val$errors;
                final /* synthetic */ Iterator val$it;
                {
                    this.val$idToDescriptorMap = map;
                    this.val$pluginDescriptor = ideaPluginDescriptor;
                    this.val$faultyDescriptors = linkedHashSet;
                    this.val$disabledPluginIds = list;
                    this.val$disabledPluginNames = map2;
                    this.val$errors = list2;
                    this.val$it = iterator;
                }

                public boolean value(PluginId pluginId) {
                    if (!this.val$idToDescriptorMap.containsKey(pluginId)) {
                        this.val$pluginDescriptor.setEnabled(false);
                        if (!pluginId.getIdString().startsWith(PluginManagerCore.MODULE_DEPENDENCY_PREFIX)) {
                            boolean disabled;
                            String pluginName;
                            this.val$faultyDescriptors.add(pluginId.getIdString());
                            this.val$disabledPluginIds.add(this.val$pluginDescriptor.getPluginId().getIdString());
                            String name = this.val$pluginDescriptor.getName();
                            IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)this.val$idToDescriptorMap.get(pluginId);
                            if (descriptor == null) {
                                pluginName = pluginId.getIdString();
                                if (this.val$disabledPluginNames.containsKey(pluginName)) {
                                    pluginName = (String)this.val$disabledPluginNames.get(pluginName);
                                }
                            } else {
                                pluginName = descriptor.getName();
                            }
                            this.val$errors.add(IdeBundle.message((String)((disabled = PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString())) ? "error.required.plugin.disabled" : "error.required.plugin.not.installed"), (Object[])new Object[]{name, pluginName}));
                        }
                        this.val$it.remove();
                        return false;
                    }
                    return true;
                }
            });
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            String error = "<br><a href=\"disable\">Disable ";
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)((String)disabledPluginIds.iterator().next()));
                error = error + (idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                error = error + "not loaded plugins";
            }
            errors.add(error + "</a>");
            boolean possibleToEnable = true;
            for (String descriptor : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                errors.add("<a href=\"enable\">Enable " + (faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins") + "</a>");
            }
            errors.add("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            errors.add(IdeBundle.message((String)"error.plugins.without.id.found", (Object[])new Object[0]));
        }
    }

    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) {
        List descriptors = ContainerUtil.newSmartList();
        PluginManagerCore.loadDescriptorsFromClassPath(descriptors, loader, null);
        return descriptors;
    }

    private static void loadDescriptorsFromClassPath(List<IdeaPluginDescriptorImpl> result, ClassLoader loader, StartupProgress progress) {
        URL resource;
        HashSet urls = ContainerUtil.newHashSet();
        String platformPrefix = System.getProperty("idea.platform.prefix");
        if (platformPrefix != null && (resource = loader.getResource("META-INF/" + platformPrefix + "Plugin.xml")) != null) {
            urls.add(resource);
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.add(enumeration.nextElement());
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info((Throwable)e);
            return;
        }
        int i = 0;
        for (URL url : urls) {
            IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptorFromResource(url);
            if (descriptor == null || result.contains(descriptor)) continue;
            descriptor.setUseCoreClassLoader(true);
            result.add(descriptor);
            if (progress == null || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) continue;
            progress.showProgress("Plugin loaded: " + descriptor.getName(), 0.3f * (float)(++i) / (float)urls.size());
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource) {
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                File pluginDir = descriptorFile.getParentFile().getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, descriptorFile.getName());
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path.substring(0, path.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, PathUtil.getFileName((String)path));
            }
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace((String)str, (String)" ", (String)"%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<IdeaPluginDescriptorImpl> result) {
        String pathProperty = System.getProperty(PROPERTY_PLUGIN_PATH);
        if (pathProperty == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), PLUGIN_XML);
            if (ideaPluginDescriptor == null) continue;
            result.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress, @NotNull List<String> errors) {
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        int pluginsCount = PluginManagerCore.countPlugins(PathManager.getPluginsPath()) + PluginManagerCore.countPlugins(PathManager.getPreInstalledPluginsPath());
        PluginManagerCore.loadDescriptors(new File(PathManager.getPluginsPath()), result, progress, pluginsCount);
        Application application = ApplicationManager.getApplication();
        boolean fromSources = false;
        if (application == null || !application.isUnitTestMode()) {
            int size = result.size();
            PluginManagerCore.loadDescriptors(new File(PathManager.getPreInstalledPluginsPath()), result, progress, pluginsCount);
            fromSources = size == result.size();
        }
        PluginManagerCore.loadDescriptorsFromProperty(result);
        PluginManagerCore.loadDescriptorsFromClassPath(result, PluginManagerCore.class.getClassLoader(), (StartupProgress)(fromSources ? progress : null));
        return PluginManagerCore.topoSortPlugins(result, errors);
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] topoSortPlugins(@NotNull List<IdeaPluginDescriptorImpl> result, @NotNull List<String> errors) {
        IdeaPluginDescriptorImpl[] pluginDescriptors = result.toArray(new IdeaPluginDescriptorImpl[result.size()]);
        THashMap idToDescriptorMap = new THashMap();
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, errors));
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        THashMap descriptorsWithModules = new THashMap(descriptors);
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor : descriptors.values()) {
            Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors = descriptor.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                descriptor.mergeOptionalConfig(entry.getValue());
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor) {
        List<File> classPath = descriptor.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), new ClassLoader[]{parentLoader}, descriptor);
        descriptor.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    @Nullable
    private static String detectReasonToNotLoad(@NotNull IdeaPluginDescriptor descriptor, @NotNull IdeaPluginDescriptor[] loaded) {
        String reasonToNotLoad;
        boolean checkModuleDependencies;
        String idString = descriptor.getPluginId().getIdString();
        if (CORE_PLUGIN_ID.equals(idString)) {
            return null;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor instanceof IdeaPluginDescriptorImpl && !descriptor.isEnabled()) {
                return "Plugin is not enabled";
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return "Plugins should not be loaded";
            }
        }
        List pluginIds = pluginId == null ? null : StringUtil.split((String)pluginId, (String)",");
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor)) {
            return "Plugin does not include any module dependency tags in its plugin.xml therefore is assumed legacy and can be loaded only in IntelliJ IDEA";
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            reasonToNotLoad = loadPluginCategory.equals(descriptor.getCategory()) ? null : "Plugin category doesn't match 'idea.load.plugins.category' value";
        } else {
            if (pluginIds != null) {
                String string = reasonToNotLoad = pluginIds.contains(idString) ? null : "'idea.load.plugins.id' doesn't contain this plugin id";
                if (reasonToNotLoad != null) {
                    THashMap map = new THashMap();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)map);
                    for (String id : pluginIds) {
                        IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map.get(PluginId.getId((String)id));
                        if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor.getPluginId(), (Map<PluginId, IdeaPluginDescriptor>)map, checkModuleDependencies)) continue;
                        reasonToNotLoad = null;
                        break;
                    }
                }
            } else {
                String string = reasonToNotLoad = PluginManagerCore.getDisabledPlugins().contains(idString) ? "Plugin is disabled" : null;
            }
            if (reasonToNotLoad == null && descriptor instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor)) {
                return "Plugin since-build or until-build don't match this product's build number";
            }
        }
        return reasonToNotLoad;
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor) {
        return !PluginManagerCore.isIncompatible(descriptor);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        return !PluginManagerCore.isIncompatible(descriptor, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor) {
        return PluginManagerCore.isIncompatible(descriptor, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            BuildNumber untilBuild;
            BuildNumber sinceBuild;
            if (!StringUtil.isEmpty((String)descriptor.getSinceBuild()) && (sinceBuild = BuildNumber.fromString((String)descriptor.getSinceBuild(), (String)descriptor.getName())).compareTo(buildNumber) > 0) {
                LOG.warn("Can't load " + descriptor + ": since build " + sinceBuild + " does not match " + buildNumber);
                return true;
            }
            if (!StringUtil.isEmpty((String)descriptor.getUntilBuild()) && !buildNumber.isSnapshot() && (untilBuild = BuildNumber.fromString((String)descriptor.getUntilBuild(), (String)descriptor.getName())).compareTo(buildNumber) < 0) {
                LOG.warn("Can't load " + descriptor + ": until build " + untilBuild + " does not match " + buildNumber);
                return true;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    public static boolean shouldSkipPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)descriptor;
            Boolean skipped = descriptorImpl.getSkipped();
            if (skipped != null) {
                return skipped;
            }
            boolean result = PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
            descriptorImpl.setSkipped(result);
            return result;
        }
        return PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
    }

    private static void initializePlugins(@Nullable StartupProgress progress) {
        int i;
        PluginManagerCore.configureExtensions();
        ArrayList errors = ContainerUtil.newArrayList();
        IdeaPluginDescriptorImpl[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress, errors);
        Class callerClass = ReflectionUtil.findCallerClass((int)1);
        assert (callerClass != null);
        ClassLoader parentLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap idToDescriptorMap = new THashMap();
        THashMap disabledPluginNames = new THashMap();
        SmartList brokenPluginsList = new SmartList();
        PluginManagerCore.fixDescriptors(pluginDescriptors, parentLoader, (Map<PluginId, IdeaPluginDescriptorImpl>)idToDescriptorMap, (Map<String, String>)disabledPluginNames, (List<String>)brokenPluginsList, result, errors);
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap);
        DFSTBuilder builder = new DFSTBuilder(graph);
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors);
        final Comparator idComparator = builder.comparator();
        Collections.sort(result, new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(@NotNull IdeaPluginDescriptor o1, @NotNull IdeaPluginDescriptor o2) {
                return idComparator.compare(o1.getPluginId(), o2.getPluginId());
            }
        });
        for (i = 0; i < result.size(); ++i) {
            ourId2Index.put((Object)((IdeaPluginDescriptorImpl)result.get(i)).getPluginId(), i);
        }
        i = 0;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result) {
            if (pluginDescriptor.getPluginId().getIdString().equals(CORE_PLUGIN_ID) || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(parentLoader);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = pluginDescriptor.getClassPath();
                PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), classLoaderArray, pluginDescriptor);
                pluginDescriptor.setLoader(pluginClassLoader);
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)i++ / (float)result.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result);
        Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension((Object)new AreaListener(){

            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea((AreaInstance)areaInstance), result);
            }

            public void areaDisposing(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
            }
        });
        ourPlugins = pluginDescriptors;
    }

    public static void fixDescriptors(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result, @NotNull List<String> errors) {
        PluginManagerCore.checkCanLoadPlugins(pluginDescriptors, parentLoader, disabledPluginNames, brokenPluginsList, result);
        PluginManagerCore.filterBadPlugins(result, disabledPluginNames, errors);
        if (!brokenPluginsList.isEmpty()) {
            errors.add("Following plugins are incompatible with current IDE build: " + StringUtil.join(brokenPluginsList, (String)", "));
        }
        PluginManagerCore.fixDependencies(result, idToDescriptorMap);
    }

    private static void checkCanLoadPlugins(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result) {
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            String toNotLoadReason = PluginManagerCore.detectReasonToNotLoad(descriptor, pluginDescriptors);
            if (toNotLoadReason == null && PluginManagerCore.isBrokenPlugin(descriptor)) {
                brokenPluginsList.add(descriptor.getName());
                toNotLoadReason = "This plugin version was marked as incompatible";
            }
            if (toNotLoadReason == null) {
                List<String> modules = descriptor.getModules();
                if (modules != null) {
                    for (String module2 : modules) {
                        if (ourModulesToContainingPlugins.containsKey(module2)) continue;
                        ourModulesToContainingPlugins.put(module2, descriptor);
                    }
                }
                result.add(descriptor);
                continue;
            }
            descriptor.setEnabled(false);
            PluginManagerCore.getLogger().info(String.format("Plugin '%s' can't be loaded because: %s", descriptor.getName(), toNotLoadReason));
            disabledPluginNames.put(descriptor.getPluginId().getIdString(), descriptor.getName());
            PluginManagerCore.initClassLoader(parentLoader, descriptor);
        }
    }

    private static void fixDependencies(@NotNull List<IdeaPluginDescriptorImpl> result, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        for (IdeaPluginDescriptorImpl descriptor : result) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        IdeaPluginDescriptor corePluginDescriptor = idToDescriptorMap.get(PluginId.getId((String)CORE_PLUGIN_ID));
        assert (corePluginDescriptor != null) : "com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl descriptor : result) {
            if (descriptor == corePluginDescriptor) continue;
            descriptor.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsArea area, @NotNull List<IdeaPluginDescriptorImpl> loadedPlugins) {
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            descriptor.registerExtensionPoints(area);
        }
        ExtensionPoint[] extensionPoints = area.getExtensionPoints();
        THashSet epNames = new THashSet(extensionPoints.length);
        for (ExtensionPoint point : extensionPoints) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            for (String epName : epNames) {
                descriptor.registerExtensions(area, epName);
            }
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor = pluginRoot.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot, fileName) : PluginManagerCore.loadDescriptorFromJar(pluginRoot, fileName);
        if (descriptor != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions(area, Collections.singletonList(descriptor));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
        }
    }

    private static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    private static class IdeaLogProvider
    implements LogProvider {
        private IdeaLogProvider() {
        }

        public void error(String message) {
            PluginManagerCore.getLogger().error(message);
        }

        public void error(String message, Throwable t) {
            PluginManagerCore.getLogger().error(message, t);
        }

        public void error(Throwable t) {
            PluginManagerCore.getLogger().error(t);
        }

        public void warn(String message) {
            PluginManagerCore.getLogger().info(message);
        }

        public void warn(String message, Throwable t) {
            PluginManagerCore.getLogger().info(message, t);
        }

        public void warn(Throwable t) {
            PluginManagerCore.getLogger().info(t);
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");

        private LoggerHolder() {
        }
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();

        private Holder() {
        }

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString((String)System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString((String)BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.fallback();
                }
            }
            return ourBuildNumber;
        }
    }
}

