/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NonBundledPluginsUsagesCollector
extends UsagesCollector {
    private static final String GROUP_ID = "non-bundled-plugins";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        return GroupDescriptor.create(GROUP_ID, 100.0);
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        Object[] plugins2 = PluginManagerCore.getPlugins();
        List nonBundledEnabledPlugins = ContainerUtil.filter((Object[])plugins2, (Condition)new Condition<IdeaPluginDescriptor>(){

            public boolean value(IdeaPluginDescriptor d) {
                return d.isEnabled() && !d.isBundled() && d.getPluginId() != null;
            }
        });
        return ContainerUtil.map2Set((Collection)nonBundledEnabledPlugins, (Function)new Function<IdeaPluginDescriptor, UsageDescriptor>(){

            public UsageDescriptor fun(IdeaPluginDescriptor descriptor) {
                return new UsageDescriptor(descriptor.getPluginId().getIdString(), 1);
            }
        });
    }
}

