/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsState {
    private final Object myLock = new Object();
    private final Map<PluginId, IdeaPluginDescriptor> myInstalledPlugins = ContainerUtil.newIdentityHashMap();
    private final Map<PluginId, IdeaPluginDescriptor> myUpdatedPlugins = ContainerUtil.newIdentityHashMap();
    private final Set<String> myOutdatedPlugins = new SmartHashSet();

    @Nullable
    public static InstalledPluginsState getInstanceIfLoaded() {
        return IdeaApplication.isLoaded() ? InstalledPluginsState.getInstance() : null;
    }

    public static InstalledPluginsState getInstance() {
        return (InstalledPluginsState)ServiceManager.getService(InstalledPluginsState.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<IdeaPluginDescriptor> getInstalledPlugins() {
        Object object = this.myLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.myInstalledPlugins.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewerVersion(@NotNull PluginId id) {
        Object object = this.myLock;
        synchronized (object) {
            return !this.wasUpdated(id) && this.myOutdatedPlugins.contains(id.getIdString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasInstalled(@NotNull PluginId id) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myInstalledPlugins.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUpdated(@NotNull PluginId id) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myUpdatedPlugins.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDescriptorDownload(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId id = descriptor.getPluginId();
        IdeaPluginDescriptor existing = PluginManager.getPlugin(id);
        if (existing == null || existing.isBundled() && !existing.allowBundledUpdate() || this.wasUpdated(id)) {
            return;
        }
        boolean supersedes = PluginManagerCore.isCompatible(descriptor) && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(existing, descriptor.getVersion()) > 0;
        String idString = id.getIdString();
        Object object = this.myLock;
        synchronized (object) {
            if (supersedes) {
                this.myOutdatedPlugins.add(idString);
            } else {
                this.myOutdatedPlugins.remove(idString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginInstall(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId id = descriptor.getPluginId();
        boolean existing = PluginManager.isPluginInstalled(id);
        Object object = this.myLock;
        synchronized (object) {
            this.myOutdatedPlugins.remove(id.getIdString());
            if (existing) {
                this.myUpdatedPlugins.put(id, descriptor);
            } else {
                this.myInstalledPlugins.put(id, descriptor);
            }
        }
    }
}

