/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.PasswordSafeTimed;
import com.intellij.ide.passwordSafe.impl.providers.BasePasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterPasswordDialog;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.PasswordDatabase;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.windows.WindowsCryptUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasterKeyPasswordSafe
extends BasePasswordSafeProvider {
    private static final String TEST_PASSWORD_KEY = "TEST_PASSWORD:";
    private static final String TEST_PASSWORD_VALUE = "test password";
    private final PasswordDatabase myDatabase;
    private final transient PasswordSafeTimed<Ref<Object>> myKey = new PasswordSafeTimed<Ref<Object>>(){

        @Override
        protected Ref<Object> compute() {
            return Ref.create();
        }

        @Override
        protected int getMinutesToLive() {
            return Registry.intValue((String)"passwordSafe.masterPassword.ttl");
        }
    };
    private static final Object ourEDTLock = new Object();

    public MasterKeyPasswordSafe(PasswordDatabase database) {
        this.myDatabase = database;
    }

    void resetMasterPassword(String password, boolean encrypt) {
        this.myKey.get().set((Object)EncryptionUtil.genPasswordKey(password));
        this.myDatabase.clear();
        try {
            this.storePassword(null, MasterKeyPasswordSafe.class, MasterKeyPasswordSafe.testKey(password), TEST_PASSWORD_VALUE);
            if (encrypt) {
                this.myDatabase.setPasswordInfo(MasterKeyPasswordSafe.encryptPassword(password));
            } else {
                this.myDatabase.setPasswordInfo(ArrayUtil.EMPTY_BYTE_ARRAY);
            }
        }
        catch (PasswordSafeException e) {
            throw new IllegalStateException("There should be no problem with password at this point", e);
        }
    }

    boolean setMasterPassword(String password) {
        String rc;
        Object savedKey = this.myKey.get().get();
        this.myKey.get().set((Object)EncryptionUtil.genPasswordKey(password));
        try {
            rc = this.getPassword(null, MasterKeyPasswordSafe.class, MasterKeyPasswordSafe.testKey(password));
        }
        catch (PasswordSafeException e) {
            throw new IllegalStateException("There should be no problem with password at this point", e);
        }
        if (!TEST_PASSWORD_VALUE.equals(rc)) {
            this.myKey.get().set(savedKey);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeMasterPassword(String oldPassword, String newPassword, boolean encrypt) {
        if (!this.setMasterPassword(oldPassword)) {
            return false;
        }
        byte[] oldKey = (byte[])this.myKey.get().get();
        byte[] newKey = EncryptionUtil.genPasswordKey(newPassword);
        ByteArrayWrapper testKey = new ByteArrayWrapper(EncryptionUtil.dbKey(oldKey, MasterKeyPasswordSafe.class, MasterKeyPasswordSafe.testKey(oldPassword)));
        HashMap<ByteArrayWrapper, byte[]> oldDb = new HashMap<ByteArrayWrapper, byte[]>();
        this.myDatabase.copyTo(oldDb);
        HashMap<ByteArrayWrapper, byte[]> newDb = new HashMap<ByteArrayWrapper, byte[]>();
        for (Map.Entry<ByteArrayWrapper, byte[]> e : oldDb.entrySet()) {
            if (testKey.equals(e.getKey())) continue;
            byte[] decryptedKey = EncryptionUtil.decryptKey(oldKey, e.getKey().unwrap());
            String decryptedText = EncryptionUtil.decryptText(oldKey, e.getValue());
            newDb.put(new ByteArrayWrapper(EncryptionUtil.encryptKey(newKey, decryptedKey)), EncryptionUtil.encryptText(newKey, decryptedText));
        }
        Object object = this.myDatabase.getDbLock();
        synchronized (object) {
            this.resetMasterPassword(newPassword, encrypt);
            this.myDatabase.putAll(newDb);
        }
        return true;
    }

    private static String testKey(String password) {
        return TEST_PASSWORD_KEY + password;
    }

    @Override
    @NotNull
    protected byte[] key(final @Nullable Project project2, final @NotNull Class requestor) throws PasswordSafeException {
        Object key = this.myKey.get().get();
        if (key instanceof byte[]) {
            return (byte[])key;
        }
        if (key instanceof PasswordSafeException && ((PasswordSafeException)key).justHappened()) {
            throw (PasswordSafeException)key;
        }
        if (this.isPasswordEncrypted()) {
            try {
                this.setMasterPassword(MasterKeyPasswordSafe.decryptPassword(this.myDatabase.getPasswordInfo()));
                key = this.myKey.get().get();
                if (key instanceof byte[]) {
                    return (byte[])key;
                }
            }
            catch (PasswordSafeException passwordSafeException) {
                // empty catch block
            }
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new MasterPasswordUnavailableException("The provider is not available in headless environment");
        }
        key = this.invokeAndWait(new ThrowableComputable<Object, PasswordSafeException>(){

            public Object compute() throws PasswordSafeException {
                Object key = ((Ref)MasterKeyPasswordSafe.this.myKey.get()).get();
                if (key instanceof byte[] || key instanceof PasswordSafeException && ((PasswordSafeException)key).justHappened()) {
                    return key;
                }
                try {
                    if (MasterKeyPasswordSafe.this.myDatabase.isEmpty()) {
                        if (!MasterPasswordDialog.resetMasterPasswordDialog(project2, MasterKeyPasswordSafe.this, requestor).showAndGet()) {
                            throw new MasterPasswordUnavailableException("Master password is required to store passwords in the database.");
                        }
                    } else {
                        MasterPasswordDialog.askPassword(project2, MasterKeyPasswordSafe.this, requestor);
                    }
                }
                catch (PasswordSafeException e) {
                    ((Ref)MasterKeyPasswordSafe.this.myKey.get()).set((Object)e);
                    throw e;
                }
                return ((Ref)MasterKeyPasswordSafe.this.myKey.get()).get();
            }
        }, project2 == null ? Conditions.alwaysFalse() : project2.getDisposed());
        if (key instanceof byte[]) {
            return (byte[])key;
        }
        if (key instanceof PasswordSafeException) {
            throw (PasswordSafeException)key;
        }
        throw new AssertionError();
    }

    public <T, E extends Throwable> T invokeAndWait(final @NotNull ThrowableComputable<T, E> computable, final @NotNull Condition<?> expired) throws E {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)computable.compute();
        }
        final AsyncFutureResult future2 = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        final ExpirableRunnable runnable2 = new ExpirableRunnable(){

            public boolean isExpired() {
                boolean b = expired.value(null);
                if (b) {
                    future2.setException((Throwable)new ProcessCanceledException());
                }
                return b;
            }

            public void run() {
                try {
                    future2.set(computable.compute());
                }
                catch (Throwable e) {
                    future2.setException(e);
                }
            }
        };
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Object object = ourEDTLock;
        synchronized (object) {
            if (indicator != null && indicator.isModal()) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!runnable2.isExpired()) {
                            runnable2.run();
                        }
                    }
                });
            } else {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(runnable2);
            }
            try {
                return (T)future2.get();
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    @Override
    public String getPassword(@Nullable Project project2, @NotNull Class requestor, String key) throws PasswordSafeException {
        if (this.myDatabase.isEmpty()) {
            return null;
        }
        return super.getPassword(project2, requestor, key);
    }

    @Override
    public void removePassword(@Nullable Project project2, @NotNull Class requester, String key) throws PasswordSafeException {
        if (this.myDatabase.isEmpty()) {
            return;
        }
        super.removePassword(project2, requester, key);
    }

    @Override
    protected byte[] getEncryptedPassword(byte[] key) {
        return this.myDatabase.get(key);
    }

    @Override
    protected void removeEncryptedPassword(byte[] key) {
        this.myDatabase.remove(key);
    }

    @Override
    protected void storeEncryptedPassword(byte[] key, byte[] encryptedPassword) {
        this.myDatabase.put(key, encryptedPassword);
    }

    @Override
    public boolean isSupported() {
        return !ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @Override
    public String getDescription() {
        return "This provider stores passwords in IDEA config and uses master password to encrypt other passwords. The passwords for the same resources are shared between different projects.";
    }

    @Override
    public String getName() {
        return "Master Key PasswordSafe";
    }

    public boolean isMasterPasswordEnabled() {
        return this.setMasterPassword("");
    }

    public boolean isOsProtectedPasswordSupported() {
        return SystemInfo.isWindows;
    }

    private static byte[] encryptPassword(String pw) throws MasterPasswordUnavailableException {
        assert (SystemInfo.isWindows);
        return WindowsCryptUtils.protect(EncryptionUtil.getUTF8Bytes(pw));
    }

    private static String decryptPassword(byte[] pw) throws MasterPasswordUnavailableException {
        if (!SystemInfo.isWindows) {
            throw new AssertionError((Object)"Windows OS expected");
        }
        return new String(WindowsCryptUtils.unprotect(pw), CharsetToolkit.UTF8_CHARSET);
    }

    public boolean isPasswordEncrypted() {
        if (!this.isOsProtectedPasswordSupported()) {
            return false;
        }
        byte[] info = this.myDatabase.getPasswordInfo();
        return info != null && info.length > 0;
    }

    public boolean isEmpty() {
        return this.myDatabase.isEmpty();
    }
}

