/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.PasswordComponentBase;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class EnterPasswordComponent
extends PasswordComponentBase {
    public EnterPasswordComponent(@NotNull MasterKeyPasswordSafe safe, @NotNull Class<?> requestor) {
        super(safe, "Enter");
        String requestorName = EnterPasswordComponent.getRequestorTitle(requestor);
        this.myPromptLabel.setText("<html><br>Master password is required to unlock the password database.<br>The password database will be unlocked during this session<br>for all subsystems.<br><br><b>Requested by</b>: " + requestorName + "</html>");
        UIUtil.setEnabled((Component)this.myNewPasswordPanel, (boolean)false, (boolean)true);
        this.myNewPasswordPanel.setVisible(false);
    }

    @Override
    public ValidationInfo doValidate() {
        return null;
    }

    @Override
    public boolean apply() {
        String password = new String(this.myPasswordField.getPassword());
        return this.mySafe.changeMasterPassword(password, password, this.myEncryptCheckBox.isSelected());
    }

    @Override
    public String getHelpId() {
        return "settings_passwords_master_password_enter";
    }
}

