/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.PasswordDatabase;
import com.intellij.ide.passwordSafe.impl.providers.memory.MemoryPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.nil.NilProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordSafeImpl
extends PasswordSafe {
    private static final Logger LOG = Logger.getInstance((String)PasswordSafeImpl.class.getName());
    private final PasswordSafeSettings mySettings;
    private final MasterKeyPasswordSafe myMasterKeyProvider;
    private final NilProvider myNilProvider;
    private final MemoryPasswordSafe myMemoryProvider;

    public PasswordSafeImpl(PasswordSafeSettings settings, PasswordDatabase database) {
        this.mySettings = settings;
        this.myMasterKeyProvider = new MasterKeyPasswordSafe(database);
        this.myNilProvider = new NilProvider();
        this.myMemoryProvider = new MemoryPasswordSafe();
    }

    private PasswordSafeProvider provider() {
        PasswordSafeProvider p = null;
        switch (this.mySettings.getProviderType()) {
            case DO_NOT_STORE: {
                p = this.myNilProvider;
                break;
            }
            case MEMORY_ONLY: {
                p = this.myMemoryProvider;
                break;
            }
            case MASTER_PASSWORD: {
                p = this.myMasterKeyProvider;
                break;
            }
            default: {
                LOG.error("Unknown provider type: " + (Object)((Object)this.mySettings.getProviderType()));
            }
        }
        if (p == null || !p.isSupported()) {
            p = this.myMemoryProvider;
        }
        return p;
    }

    public PasswordSafeSettings getSettings() {
        return this.mySettings;
    }

    @Override
    @Nullable
    public String getPassword(@Nullable Project project2, @NotNull Class requester, String key) throws PasswordSafeException {
        if (this.mySettings.getProviderType().equals((Object)PasswordSafeSettings.ProviderType.MASTER_PASSWORD)) {
            String password = this.getMemoryProvider().getPassword(project2, requester, key);
            if (password == null && (password = this.provider().getPassword(project2, requester, key)) != null) {
                this.getMemoryProvider().storePassword(project2, requester, key, password);
            }
            return password;
        }
        return this.provider().getPassword(project2, requester, key);
    }

    @Override
    public void removePassword(@Nullable Project project2, @NotNull Class requester, String key) throws PasswordSafeException {
        if (this.mySettings.getProviderType().equals((Object)PasswordSafeSettings.ProviderType.MASTER_PASSWORD)) {
            this.getMemoryProvider().removePassword(project2, requester, key);
        }
        this.provider().removePassword(project2, requester, key);
    }

    @Override
    public void storePassword(@Nullable Project project2, @NotNull Class requester, String key, String value) throws PasswordSafeException {
        if (this.mySettings.getProviderType().equals((Object)PasswordSafeSettings.ProviderType.MASTER_PASSWORD)) {
            this.getMemoryProvider().storePassword(project2, requester, key, value);
        }
        this.provider().storePassword(project2, requester, key, value);
    }

    public MasterKeyPasswordSafe getMasterKeyProvider() {
        return this.myMasterKeyProvider;
    }

    public MemoryPasswordSafe getMemoryProvider() {
        return this.myMemoryProvider;
    }
}

