/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectInTargetPsiWrapper
implements SelectInTarget {
    protected final Project myProject;

    protected SelectInTargetPsiWrapper(@NotNull Project project2) {
        this.myProject = project2;
    }

    public abstract String toString();

    protected abstract boolean canSelect(PsiFileSystemItem var1);

    public final boolean canSelect(@NotNull SelectInContext context) {
        if (!this.isContextValid(context)) {
            return false;
        }
        return this.canWorkWithCustomObjects() || this.canSelectInner(context);
    }

    protected boolean canSelectInner(@NotNull SelectInContext context) {
        PsiFileSystemItem psiFile = this.getContextPsiFile(context);
        return psiFile != null && this.canSelect(psiFile);
    }

    private boolean isContextValid(SelectInContext context) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VirtualFile virtualFile = context.getVirtualFile();
        return virtualFile.isValid();
    }

    @Nullable
    protected PsiFileSystemItem getContextPsiFile(@NotNull SelectInContext context) {
        VirtualFile virtualFile = context.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        Object psiFile = document != null ? PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document) : (context.getSelectorInFile() instanceof PsiFile ? (PsiFile)context.getSelectorInFile() : (virtualFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile) : PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)));
        return psiFile;
    }

    public final void selectIn(@NotNull SelectInContext context, boolean requestFocus) {
        VirtualFile file2 = context.getVirtualFile();
        Object selector = context.getSelectorInFile();
        if (selector == null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Object object = selector = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
        }
        if (selector instanceof PsiElement) {
            this.select(((PsiElement)selector).getOriginalElement(), requestFocus);
        } else {
            this.select(selector, file2, requestFocus);
        }
    }

    protected abstract void select(Object var1, VirtualFile var2, boolean var3);

    protected abstract boolean canWorkWithCustomObjects();

    protected abstract void select(PsiElement var1, boolean var2);
}

