/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class ProjectViewSelectInGroupTarget
implements CompositeSelectInTarget,
DumbAware {
    @NotNull
    public Collection<SelectInTarget> getSubTargets(@NotNull SelectInContext context) {
        return ProjectView.getInstance(context.getProject()).getSelectInTargets();
    }

    public boolean canSelect(SelectInContext context) {
        ProjectView projectView = ProjectView.getInstance(context.getProject());
        Collection<SelectInTarget> targets = projectView.getSelectInTargets();
        for (SelectInTarget projectViewTarget : targets) {
            if (!projectViewTarget.canSelect(context)) continue;
            return true;
        }
        return false;
    }

    public void selectIn(final SelectInContext context, final boolean requestFocus) {
        ProjectView projectView = ProjectView.getInstance(context.getProject());
        Collection<SelectInTarget> targets = projectView.getSelectInTargets();
        LinkedHashSet<SelectInTarget> targetsToCheck = new LinkedHashSet<SelectInTarget>();
        String currentId = projectView.getCurrentViewId();
        for (SelectInTarget projectViewTarget : targets) {
            if (!Comparing.equal((String)currentId, (String)projectViewTarget.getMinorViewId())) continue;
            targetsToCheck.add(projectViewTarget);
            break;
        }
        targetsToCheck.addAll(targets);
        for (final SelectInTarget target : targetsToCheck) {
            if (!target.canSelect(context)) continue;
            if (requestFocus) {
                IdeFocusManager.getInstance((Project)context.getProject()).requestFocus(new FocusCommand(){

                    @NotNull
                    public ActionCallback run() {
                        target.selectIn(context, requestFocus);
                        return ActionCallback.DONE;
                    }
                }, true);
                break;
            }
            target.selectIn(context, requestFocus);
            break;
        }
    }

    public String getToolWindowId() {
        return ToolWindowId.PROJECT_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 0.0f;
    }

    public String toString() {
        return "Project View";
    }
}

