/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class SupertypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    public SupertypesHierarchyTreeStructure(Project project2, PsiClass aClass) {
        super(project2, new TypeHierarchyNodeDescriptor(project2, null, (PsiElement)aClass, true));
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiClass functionalInterfaceClass;
        PsiElement element = ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            PsiClass[] supers = psiClass.getSupers();
            ArrayList<TypeHierarchyNodeDescriptor> descriptors = new ArrayList<TypeHierarchyNodeDescriptor>();
            PsiClass objectClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("java.lang.Object", psiClass.getResolveScope());
            for (PsiClass aSuper : supers) {
                if (psiClass.isInterface() && aSuper.equals(objectClass)) continue;
                descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)aSuper, false));
            }
            return descriptors.toArray(new HierarchyNodeDescriptor[descriptors.size()]);
        }
        if (element instanceof PsiFunctionalExpression && (functionalInterfaceClass = PsiUtil.resolveClassInType((PsiType)((PsiFunctionalExpression)element).getFunctionalInterfaceType())) != null) {
            return new HierarchyNodeDescriptor[]{new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)functionalInterfaceClass, false)};
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

