/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class HierarchyTreeBuilder
extends AbstractTreeBuilder {
    HierarchyTreeBuilder(@NotNull Project project2, JTree tree, DefaultTreeModel treeModel, HierarchyTreeStructure treeStructure, Comparator<NodeDescriptor> comparator2) {
        super(tree, treeModel, (AbstractTreeStructure)treeStructure, comparator2);
        this.initRootNode();
        PsiManager.getInstance((Project)project2).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener(), (Disposable)this);
        FileStatusManager.getInstance((Project)project2).addFileStatusListener((FileStatusListener)new MyFileStatusListener(), (Disposable)this);
    }

    @NotNull
    public Pair<List<Object>, List<Object>> storeExpandedAndSelectedInfo() {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        return Pair.create(pathsToExpand, selectionPaths);
    }

    public final void restoreExpandedAndSelectedInfo(@NotNull Pair<List<Object>, List<Object>> pair) {
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, (List)((List)pair.first), (List)((List)pair.second), (boolean)true);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((HierarchyTreeStructure)this.getTreeStructure()).isAlwaysShowPlus();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return this.getTreeStructure().getRootElement().equals(nodeDescriptor.getElement()) || !(nodeDescriptor instanceof HierarchyNodeDescriptor);
    }

    protected final boolean isSmartExpand() {
        return false;
    }

    protected final boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return false;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        return new StatusBarProgress();
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public final void fileStatusesChanged() {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public final void childAdded(@NotNull PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childRemoved(@NotNull PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childReplaced(@NotNull PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childMoved(@NotNull PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }
    }
}

