/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTemplateBase
implements FileTemplate {
    public static final boolean DEFAULT_REFORMAT_CODE_VALUE = true;
    public static final boolean DEFAULT_ENABLED_VALUE = true;
    @Nullable
    private String myText;
    private boolean myShouldReformatCode = true;
    private boolean myLiveTemplateEnabled;

    @Override
    public final boolean isReformatCode() {
        return this.myShouldReformatCode;
    }

    @Override
    public final void setReformatCode(boolean reformat) {
        this.myShouldReformatCode = reformat;
    }

    public final String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    public static String getQualifiedName(String name, String extension) {
        return FTManager.encodeFileName(name, extension);
    }

    @Override
    @NotNull
    public final String getText() {
        String text = this.myText;
        return text != null ? text : this.getDefaultText();
    }

    @Override
    public final void setText(@Nullable String text) {
        String converted;
        this.myText = text == null ? null : ((converted = StringUtil.convertLineSeparators((String)text)).equals(this.getDefaultText()) ? null : converted);
    }

    @NotNull
    protected String getDefaultText() {
        return "";
    }

    @Override
    @NotNull
    public final String getText(Map attributes) throws IOException {
        return FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
    }

    @Override
    @NotNull
    public final String getText(Properties attributes) throws IOException {
        return FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
    }

    @Override
    @NotNull
    public final String[] getUnsetAttributes(@NotNull Properties properties, Project project2) throws ParseException {
        return FileTemplateUtil.calculateAttributes(this.getText(), properties, false, project2);
    }

    @Override
    public FileTemplateBase clone() {
        try {
            return (FileTemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTemplateOfType(@NotNull FileType fType) {
        return fType.equals(FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(this.getExtension()));
    }

    @Override
    public boolean isLiveTemplateEnabled() {
        return this.myLiveTemplateEnabled;
    }

    @Override
    public void setLiveTemplateEnabled(boolean value) {
        this.myLiveTemplateEnabled = value;
    }

    public boolean isLiveTemplateEnabledByDefault() {
        return false;
    }
}

