/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FTManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FTManager");
    public static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    public static final String TEMPLATE_EXTENSION_SUFFIX = ".ft";
    private static final String ENCODED_NAME_EXT_DELIMITER = "\u0f0fext\u0f0f.";
    private final String myName;
    private final boolean myInternal;
    private final String myTemplatesDir;
    @Nullable
    private final FTManager myOriginal;
    private FileTemplatesScheme myScheme = FileTemplatesScheme.DEFAULT;
    private final Map<String, FileTemplateBase> myTemplates = new HashMap<String, FileTemplateBase>();
    private volatile List<FileTemplateBase> mySortedTemplates;
    private final List<DefaultTemplate> myDefaultTemplates = new ArrayList<DefaultTemplate>();

    FTManager(@NotNull @NonNls String name, @NotNull @NonNls String defaultTemplatesDirName) {
        this(name, defaultTemplatesDirName, false);
    }

    FTManager(@NotNull @NonNls String name, @NotNull @NonNls String defaultTemplatesDirName, boolean internal) {
        this.myName = name;
        this.myInternal = internal;
        this.myTemplatesDir = defaultTemplatesDirName;
        this.myOriginal = null;
    }

    FTManager(@NotNull FTManager original) {
        this.myOriginal = original;
        this.myName = original.getName();
        this.myTemplatesDir = original.myTemplatesDir;
        this.myInternal = original.myInternal;
        this.myTemplates.putAll(original.myTemplates);
        this.myDefaultTemplates.addAll(original.myDefaultTemplates);
    }

    public String getName() {
        return this.myName;
    }

    public void setScheme(FileTemplatesScheme scheme) {
        this.mySortedTemplates = null;
        this.myScheme = scheme;
        this.loadCustomizedContent();
    }

    @NotNull
    public Collection<FileTemplateBase> getAllTemplates(boolean includeDisabled) {
        List<FileTemplateBase> sorted = this.mySortedTemplates;
        if (sorted == null) {
            sorted = new ArrayList<FileTemplateBase>(this.getTemplates().values());
            Collections.sort(sorted, new Comparator<FileTemplateBase>(){

                @Override
                public int compare(FileTemplateBase t1, FileTemplateBase t2) {
                    return t1.getName().compareToIgnoreCase(t2.getName());
                }
            });
            this.mySortedTemplates = sorted;
        }
        if (includeDisabled) {
            return Collections.unmodifiableCollection(sorted);
        }
        ArrayList<FileTemplateBase> list = new ArrayList<FileTemplateBase>(sorted.size());
        for (FileTemplateBase template : sorted) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) continue;
            list.add(template);
        }
        return list;
    }

    @Nullable
    public FileTemplateBase getTemplate(@NotNull String templateQname) {
        return this.getTemplates().get(templateQname);
    }

    @Nullable
    public FileTemplateBase findTemplateByName(@NotNull String templateName) {
        FileTemplateBase template = this.getTemplates().get(templateName);
        if (template != null) {
            boolean isEnabled;
            boolean bl = isEnabled = !(template instanceof BundledFileTemplate) || ((BundledFileTemplate)template).isEnabled();
            if (isEnabled) {
                return template;
            }
        }
        for (FileTemplateBase t : this.getAllTemplates(false)) {
            String remainder;
            String qName = t.getQualifiedName();
            if (!qName.startsWith(templateName) || qName.length() <= templateName.length() || !(remainder = qName.substring(templateName.length())).startsWith(ENCODED_NAME_EXT_DELIMITER) && remainder.charAt(0) != '.') continue;
            return t;
        }
        return null;
    }

    @NotNull
    public FileTemplateBase addTemplate(String name, String extension) {
        String qName = FileTemplateBase.getQualifiedName(name, extension);
        FileTemplateBase template = this.getTemplate(qName);
        if (template == null) {
            template = new CustomFileTemplate(name, extension);
            this.getTemplates().put(qName, template);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) {
            ((BundledFileTemplate)template).setEnabled(true);
        }
        return template;
    }

    public void removeTemplate(@NotNull String qName) {
        FileTemplateBase template = this.getTemplates().get(qName);
        if (template instanceof CustomFileTemplate) {
            this.getTemplates().remove(qName);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    public void updateTemplates(@NotNull Collection<FileTemplate> newTemplates) {
        HashSet<String> toDisable = new HashSet<String>();
        for (DefaultTemplate defaultTemplate : this.myDefaultTemplates) {
            toDisable.add(defaultTemplate.getQualifiedName());
        }
        for (FileTemplate fileTemplate : newTemplates) {
            toDisable.remove(((FileTemplateBase)fileTemplate).getQualifiedName());
        }
        this.restoreDefaults(toDisable);
        for (FileTemplate fileTemplate : newTemplates) {
            FileTemplateBase _template = this.addTemplate(fileTemplate.getName(), fileTemplate.getExtension());
            _template.setText(fileTemplate.getText());
            _template.setReformatCode(fileTemplate.isReformatCode());
            _template.setLiveTemplateEnabled(fileTemplate.isLiveTemplateEnabled());
        }
    }

    private void restoreDefaults(Set<String> toDisable) {
        this.getTemplates().clear();
        this.mySortedTemplates = null;
        for (DefaultTemplate template : this.myDefaultTemplates) {
            BundledFileTemplate bundled = this.createAndStoreBundledTemplate(template);
            if (!toDisable.contains(bundled.getQualifiedName())) continue;
            bundled.setEnabled(false);
        }
    }

    public void addDefaultTemplate(DefaultTemplate template) {
        this.myDefaultTemplates.add(template);
        this.createAndStoreBundledTemplate(template);
    }

    private BundledFileTemplate createAndStoreBundledTemplate(DefaultTemplate template) {
        BundledFileTemplate bundled = new BundledFileTemplate(template, this.myInternal);
        String qName = bundled.getQualifiedName();
        FileTemplateBase previous = this.getTemplates().put(qName, bundled);
        this.mySortedTemplates = null;
        LOG.assertTrue(previous == null, (Object)("Duplicate bundled template " + qName + " [" + template.getTemplateURL() + ", " + previous + ']'));
        return bundled;
    }

    void loadCustomizedContent() {
        File configRoot = this.getConfigRoot(false);
        File[] configFiles = configRoot.listFiles();
        if (configFiles == null) {
            return;
        }
        ArrayList<File> templateWithDefaultExtension = new ArrayList<File>();
        HashSet<String> processedNames = new HashSet<String>();
        for (File file2 : configFiles) {
            if (file2.isDirectory() || FileTypeManager.getInstance().isFileIgnored(file2.getName()) || file2.isHidden()) continue;
            String name = file2.getName();
            if (name.endsWith(TEMPLATE_EXTENSION_SUFFIX)) {
                templateWithDefaultExtension.add(file2);
                continue;
            }
            processedNames.add(name);
            this.addTemplateFromFile(name, file2);
        }
        for (File file3 : templateWithDefaultExtension) {
            String name = file3.getName();
            if (!processedNames.contains(name = name.substring(0, name.length() - TEMPLATE_EXTENSION_SUFFIX.length()))) {
                this.addTemplateFromFile(name, file3);
            }
            FileUtil.delete((File)file3);
        }
    }

    private void addTemplateFromFile(String fileName, File file2) {
        Pair<String, String> nameExt = FTManager.decodeFileName(fileName);
        String extension = (String)nameExt.second;
        String templateQName = (String)nameExt.first;
        if (templateQName.length() == 0) {
            return;
        }
        try {
            String text = FileUtil.loadFile((File)file2, (Charset)CharsetToolkit.UTF8_CHARSET);
            this.addTemplate(templateQName, extension).setText(text);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void saveTemplates() {
        HashMap<String, File> templatesOnDisk;
        File configRoot = this.getConfigRoot(true);
        File[] files = configRoot.listFiles();
        HashSet<String> allNames = new HashSet<String>();
        HashMap<String, File> hashMap = templatesOnDisk = files != null && files.length > 0 ? new HashMap<String, File>() : Collections.emptyMap();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) continue;
                String name = file2.getName();
                templatesOnDisk.put(name, file2);
                allNames.add(name);
            }
        }
        HashMap<String, FileTemplateBase> templatesToSave = new HashMap<String, FileTemplateBase>();
        for (FileTemplateBase template : this.getAllTemplates(true)) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isTextModified()) continue;
            String name = template.getQualifiedName();
            templatesToSave.put(name, template);
            allNames.add(name);
        }
        if (!allNames.isEmpty()) {
            String lineSeparator = CodeStyleSettingsManager.getSettings((Project)ProjectManagerEx.getInstanceEx().getDefaultProject()).getLineSeparator();
            for (String name : allNames) {
                File customizedTemplateFile = (File)templatesOnDisk.get(name);
                FileTemplateBase templateToSave = (FileTemplateBase)templatesToSave.get(name);
                if (customizedTemplateFile == null) {
                    try {
                        FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to save template " + name, (Throwable)e);
                    }
                    continue;
                }
                if (templateToSave == null) {
                    FileUtil.delete((File)customizedTemplateFile);
                    continue;
                }
                try {
                    String templateText;
                    String diskText = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)customizedTemplateFile, (Charset)CharsetToolkit.UTF8_CHARSET));
                    if (diskText.equals(templateText = templateToSave.getText())) continue;
                    FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                }
                catch (IOException e) {
                    LOG.error("Unable to save template " + name, (Throwable)e);
                }
            }
        }
    }

    private static void saveTemplate(File parentDir, FileTemplateBase template, String lineSeparator) throws IOException {
        FileOutputStream fileOutputStream;
        File templateFile = new File(parentDir, FTManager.encodeFileName(template.getName(), template.getExtension()));
        try {
            fileOutputStream = new FileOutputStream(templateFile);
        }
        catch (FileNotFoundException e) {
            FileUtil.delete((File)templateFile);
            fileOutputStream = new FileOutputStream(templateFile);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, CharsetToolkit.UTF8_CHARSET);
        String content = template.getText();
        if (!lineSeparator.equals("\n")) {
            content = StringUtil.convertLineSeparators((String)content, (String)lineSeparator);
        }
        outputStreamWriter.write(content);
        outputStreamWriter.close();
        fileOutputStream.close();
    }

    public File getConfigRoot(boolean create) {
        File templatesPath;
        File file2 = templatesPath = this.myTemplatesDir.isEmpty() ? new File(this.myScheme.getTemplatesDir()) : new File(this.myScheme.getTemplatesDir(), this.myTemplatesDir);
        if (create && !templatesPath.mkdirs() && !templatesPath.exists()) {
            LOG.info("Cannot create directory: " + templatesPath.getAbsolutePath());
        }
        return templatesPath;
    }

    public String toString() {
        return this.myName + " file template manager";
    }

    public static String encodeFileName(String templateName, String extension) {
        String nameExtDelimiter = extension.contains(".") ? ENCODED_NAME_EXT_DELIMITER : ".";
        return templateName + nameExtDelimiter + extension;
    }

    public static Pair<String, String> decodeFileName(String fileName) {
        String name = fileName;
        String ext = "";
        String nameExtDelimiter = fileName.contains(ENCODED_NAME_EXT_DELIMITER) ? ENCODED_NAME_EXT_DELIMITER : ".";
        int extIndex = fileName.lastIndexOf(nameExtDelimiter);
        if (extIndex >= 0) {
            name = fileName.substring(0, extIndex);
            ext = fileName.substring(extIndex + nameExtDelimiter.length());
        }
        return Pair.create((Object)name, (Object)ext);
    }

    public Map<String, FileTemplateBase> getTemplates() {
        return this.myOriginal != null && this.myScheme == FileTemplatesScheme.DEFAULT ? this.myOriginal.myTemplates : this.myTemplates;
    }
}

