/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTemplate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.DefaultTemplate");
    private final String myName;
    private final String myExtension;
    private final URL myTemplateURL;
    @Nullable
    private final URL myDescriptionURL;
    private final String myText;
    private final String myDescriptionText;

    public DefaultTemplate(@NotNull String name, @NotNull String extension, @NotNull URL templateURL, @Nullable URL descriptionURL) {
        this.myName = name;
        this.myExtension = extension;
        this.myTemplateURL = templateURL;
        this.myDescriptionURL = descriptionURL;
        this.myText = DefaultTemplate.loadText(templateURL);
        this.myDescriptionText = descriptionURL != null ? DefaultTemplate.loadText(descriptionURL) : "";
    }

    private static String loadText(URL url) {
        String text = "";
        try {
            text = StringUtil.convertLineSeparators((String)UrlUtil.loadText(url));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return text;
    }

    public String getName() {
        return this.myName;
    }

    public String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    public String getExtension() {
        return this.myExtension;
    }

    public URL getTemplateURL() {
        return this.myTemplateURL;
    }

    @Nullable
    public URL getDescriptionURL() {
        return this.myDescriptionURL;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getDescriptionText() {
        return this.myDescriptionText;
    }
}

