/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.EditFileTemplatesAction;
import com.intellij.ide.fileTemplates.CreateFromTemplateActionReplacer;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.fileTemplates.ui.SelectTemplateDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateGroup
extends ActionGroup
implements DumbAware {
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 != null) {
            FileTemplate[] allTemplates;
            for (FileTemplate template : allTemplates = FileTemplateManager.getInstance(project2).getAllTemplates()) {
                if (!CreateFromTemplateGroup.canCreateFromTemplate(e, template)) continue;
                presentation.setEnabled(true);
                return;
            }
        }
        presentation.setEnabled(false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        boolean showAll;
        if (e == null) {
            return EMPTY_ARRAY;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null || project2.isDisposed()) {
            return EMPTY_ARRAY;
        }
        FileTemplateManager manager = FileTemplateManager.getInstance(project2);
        FileTemplate[] templates = manager.getAllTemplates();
        boolean bl = showAll = templates.length <= 25;
        if (!showAll) {
            Collection<String> recentNames = manager.getRecentNames();
            templates = new FileTemplate[recentNames.size()];
            int i = 0;
            for (String name : recentNames) {
                templates[i] = manager.getTemplate(name);
                ++i;
            }
        }
        Arrays.sort(templates, new Comparator<FileTemplate>(){

            @Override
            public int compare(FileTemplate template1, FileTemplate template2) {
                if (template1.isTemplateOfType((FileType)StdFileTypes.JAVA) && !template2.isTemplateOfType((FileType)StdFileTypes.JAVA)) {
                    return -1;
                }
                if (template2.isTemplateOfType((FileType)StdFileTypes.JAVA) && !template1.isTemplateOfType((FileType)StdFileTypes.JAVA)) {
                    return 1;
                }
                int i = template1.getExtension().compareTo(template2.getExtension());
                if (i != 0) {
                    return i;
                }
                return template1.getName().compareTo(template2.getName());
            }
        });
        ArrayList<Object> result = new ArrayList<Object>();
        for (FileTemplate template : templates) {
            if (!CreateFromTemplateGroup.canCreateFromTemplate(e, template)) continue;
            AnAction action = CreateFromTemplateGroup.replaceAction(template);
            if (action == null) {
                action = new CreateFromTemplateAction(template);
            }
            result.add(action);
        }
        if (!result.isEmpty() || !showAll) {
            if (!showAll) {
                result.add((Object)new CreateFromTemplatesAction(IdeBundle.message((String)"action.from.file.template", (Object[])new Object[0])));
            }
            result.add(Separator.getInstance());
            result.add((Object)new EditFileTemplatesAction(IdeBundle.message((String)"action.edit.file.templates", (Object[])new Object[0])));
        }
        return result.toArray(new AnAction[result.size()]);
    }

    private static AnAction replaceAction(FileTemplate template) {
        CreateFromTemplateActionReplacer[] actionFactories;
        for (CreateFromTemplateActionReplacer actionFactory : actionFactories = (CreateFromTemplateActionReplacer[])ApplicationManager.getApplication().getExtensions(CreateFromTemplateActionReplacer.CREATE_FROM_TEMPLATE_REPLACER)) {
            AnAction action = actionFactory.replaceCreateFromFileTemplateAction(template);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    static boolean canCreateFromTemplate(AnActionEvent e, FileTemplate template) {
        if (e == null) {
            return false;
        }
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return false;
        }
        PsiDirectory[] dirs = view.getDirectories();
        if (dirs.length == 0) {
            return false;
        }
        return FileTemplateUtil.canCreateFromTemplate(dirs, template);
    }

    private static class CreateFromTemplatesAction
    extends CreateFromTemplateActionBase {
        public CreateFromTemplatesAction(String title) {
            super(title, null, null);
        }

        @Override
        protected AnAction getReplacedAction(FileTemplate template) {
            return CreateFromTemplateGroup.replaceAction(template);
        }

        @Override
        protected FileTemplate getTemplate(Project project2, PsiDirectory dir) {
            SelectTemplateDialog dialog = new SelectTemplateDialog(project2, dir);
            dialog.show();
            return dialog.getSelectedTemplate();
        }
    }
}

