/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.smartPointerPsiNodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSmartPointerPsiNode<Type extends SmartPsiElementPointer>
extends ProjectViewNode<Type>
implements PsiElementNavigationItem {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.nodes.BasePsiNode");

    protected BaseSmartPointerPsiNode(Project project2, Type value, ViewSettings viewSettings) {
        super(project2, value, viewSettings);
    }

    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        PsiElement value = this.getPsiElement();
        if (value == null) {
            return new ArrayList<AbstractTreeNode>();
        }
        LOG.assertTrue(value.isValid());
        return this.getChildrenImpl();
    }

    @NotNull
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected boolean isMarkReadOnly() {
        Object parentValue = this.getParentValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof PackageElement;
    }

    public PsiElement getTargetElement() {
        VirtualFile file2 = this.getVirtualFileForValue();
        if (file2 == null) {
            return null;
        }
        return file2.isDirectory() ? PsiManager.getInstance((Project)this.getProject()).findDirectory(file2) : PsiManager.getInstance((Project)this.getProject()).findFile(file2);
    }

    private VirtualFile getVirtualFileForValue() {
        PsiElement value = this.getPsiElement();
        if (value == null) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)value);
    }

    protected abstract void updateImpl(PresentationData var1);

    public void update(PresentationData data) {
        PsiElement value = this.getPsiElement();
        if (value == null || !value.isValid()) {
            this.setValue(null);
        }
        if (this.getPsiElement() == null) {
            return;
        }
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        LOG.assertTrue(value.isValid());
        Icon icon = value.getIcon(flags);
        data.setIcon(icon);
        data.setPresentableText(this.myName);
        if (this.isDeprecated()) {
            data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        }
        this.updateImpl(data);
        for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
            decorator.decorate(this, data);
        }
    }

    private boolean isDeprecated() {
        PsiElement element = this.getPsiElement();
        return element instanceof PsiDocCommentOwner && element.isValid() && ((PsiDocCommentOwner)element).isDeprecated();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (this.getPsiElement() == null) {
            return false;
        }
        PsiFile containingFile = this.getPsiElement().getContainingFile();
        return file2.equals(containingFile.getVirtualFile());
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            ((NavigationItem)this.getPsiElement()).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigateToSource();
    }

    protected PsiElement getPsiElement() {
        SmartPsiElementPointer value = (SmartPsiElementPointer)this.getValue();
        return value == null ? null : value.getElement();
    }
}

