/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class FavoritesTreeStructure
extends ProjectTreeStructure {
    private static final Logger LOGGER = Logger.getInstance(FavoritesTreeStructure.class);

    public FavoritesTreeStructure(Project project2) {
        super(project2, "Favorites");
    }

    @Override
    protected AbstractTreeNode createRoot(Project project2, ViewSettings settings) {
        return new FavoritesRootNode(project2);
    }

    public void rootsChanged() {
        ((FavoritesRootNode)((Object)this.getRootElement())).rootsChanged();
    }

    @Override
    public Object[] getChildElements(Object element) {
        if (!(element instanceof AbstractTreeNode)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        AbstractTreeNode favTreeElement = (AbstractTreeNode)element;
        try {
            if (!(element instanceof FavoritesListNode)) {
                return super.getChildElements(favTreeElement);
            }
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            FavoritesListNode listNode = (FavoritesListNode)((Object)element);
            if (listNode.getProvider() != null) {
                return ArrayUtil.toObjectArray(listNode.getChildren());
            }
            Collection<AbstractTreeNode> roots = FavoritesListNode.getFavoritesRoots(this.myProject, listNode.getName(), listNode);
            for (AbstractTreeNode abstractTreeNode : roots) {
                Object value = abstractTreeNode.getValue();
                if (value == null || value instanceof PsiElement && !((PsiElement)value).isValid() || value instanceof SmartPsiElementPointer && ((SmartPsiElementPointer)value).getElement() == null) continue;
                boolean invalid = false;
                for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                    if (!nodeProvider.isInvalidElement(value)) continue;
                    invalid = true;
                    break;
                }
                if (invalid) continue;
                result.add(abstractTreeNode);
            }
            return ArrayUtil.toObjectArray(result);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private AbstractTreeNode<String> getEmptyScreen() {
        return new AbstractTreeNode<String>(this.myProject, IdeBundle.message((String)"favorites.empty.screen", (Object[])new Object[0])){

            @NotNull
            public Collection<AbstractTreeNode> getChildren() {
                return Collections.emptyList();
            }

            public void update(PresentationData presentation) {
                presentation.setPresentableText((String)this.getValue());
            }
        };
    }

    @Override
    public Object getParentElement(Object element) {
        AbstractTreeNode parent = null;
        if (element == this.getRootElement()) {
            return null;
        }
        if (element instanceof AbstractTreeNode) {
            parent = ((AbstractTreeNode)element).getParent();
        }
        if (parent == null) {
            return this.getRootElement();
        }
        return parent;
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        return new FavoritesTreeNodeDescriptor(this.myProject, parentDescriptor, (AbstractTreeNode)element);
    }
}

