/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFavoritesListProvider<T>
implements FavoritesListProvider {
    public static final int BOOKMARKS_WEIGHT = 100;
    public static final int BREAKPOINTS_WEIGHT = 200;
    public static final int TASKS_WEIGHT = 300;
    protected final Project myProject;
    private final String myListName;
    protected final List<AbstractTreeNode<T>> myChildren = new ArrayList<AbstractTreeNode<T>>();
    protected final FavoritesListNode myNode;

    protected AbstractFavoritesListProvider(@NotNull Project project2, String listName) {
        this(project2, listName, null);
    }

    protected AbstractFavoritesListProvider(@NotNull Project project2, String listName, @Nullable String description) {
        this.myProject = project2;
        this.myListName = listName;
        this.myNode = new FavoritesListNode(project2, listName, description){

            @Override
            @NotNull
            public Collection<? extends AbstractTreeNode> getChildren() {
                return AbstractFavoritesListProvider.this.myChildren;
            }

            @Override
            public FavoritesListProvider getProvider() {
                return AbstractFavoritesListProvider.this;
            }
        };
    }

    @Override
    public String getListName(Project project2) {
        return this.myListName;
    }

    @Override
    @Nullable
    public FavoritesListNode createFavoriteListNode(Project project2) {
        return this.myNode;
    }

    @Override
    public int compare(FavoritesTreeNodeDescriptor o1, FavoritesTreeNodeDescriptor o2) {
        return o1.getIndex() - o2.getIndex();
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project2, @NotNull Set<Object> selectedObjects) {
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project2, @NotNull Set<Object> selectedObjects, JComponent component) {
    }

    @Override
    public int compareTo(FavoritesListProvider o) {
        if (this.getWeight() > o.getWeight()) {
            return 1;
        }
        if (this.getWeight() < o.getWeight()) {
            return -1;
        }
        return 0;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
    }
}

