/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinuxDragAndDropSupport {
    public static final DataFlavor uriListFlavor = FileCopyPasteUtil.createDataFlavor("text/uri-list", String.class);
    public static final DataFlavor gnomeFileListFlavor = FileCopyPasteUtil.createDataFlavor("x-special/gnome-copied-files", null, true);
    public static final DataFlavor kdeCutMarkFlavor = FileCopyPasteUtil.createDataFlavor("application/x-kde-cutselection", null, true);

    private LinuxDragAndDropSupport() {
    }

    @Nullable
    public static List<File> getFiles(@NotNull Transferable transferable) throws IOException, UnsupportedFlavorException {
        if (transferable.isDataFlavorSupported(uriListFlavor)) {
            Object transferData = transferable.getTransferData(uriListFlavor);
            return LinuxDragAndDropSupport.getFiles(transferData.toString());
        }
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            Object transferData = transferable.getTransferData(gnomeFileListFlavor);
            String content = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
            return LinuxDragAndDropSupport.getFiles(content);
        }
        return null;
    }

    @NotNull
    private static List<File> getFiles(@Nullable String transferData) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (transferData != null) {
            String[] uriList;
            for (String uriString : uriList = StringUtil.convertLineSeparators((String)transferData).split("\n")) {
                if (StringUtil.isEmptyOrSpaces((String)uriString) || uriString.startsWith("#") || !uriString.startsWith("file:/")) continue;
                try {
                    URI uri = new URI(uriString);
                    fileList.add(new File(uri));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return fileList;
    }

    @NotNull
    public static String toUriList(@NotNull List<File> files) {
        return StringUtil.join(files, (Function)new Function<File, String>(){

            public String fun(File file2) {
                return file2.toURI().toString();
            }
        }, (String)"\n");
    }

    public static boolean isMoveOperation(@NotNull Transferable transferable) {
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            try {
                Object transferData = transferable.getTransferData(gnomeFileListFlavor);
                String content = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
                return content.startsWith("cut\n");
            }
            catch (Exception exception) {}
        } else if (transferable.isDataFlavorSupported(kdeCutMarkFlavor)) {
            return true;
        }
        return false;
    }
}

