/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.impl;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebBrowserServiceImpl
extends WebBrowserService {
    @NotNull
    public Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl) throws WebBrowserUrlProvider.BrowserException {
        VirtualFile file2;
        boolean isHtmlOrXml = WebBrowserServiceImpl.isHtmlOrXmlFile((Language)request.getFile().getViewProvider().getBaseLanguage());
        if (!preferLocalUrl || !isHtmlOrXml) {
            DumbService dumbService = DumbService.getInstance((Project)request.getProject());
            for (WebBrowserUrlProvider urlProvider : (WebBrowserUrlProvider[])WebBrowserUrlProvider.EP_NAME.getExtensions()) {
                Collection<Url> urls;
                if (dumbService.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request) || (urls = WebBrowserServiceImpl.getUrls(urlProvider, request)).isEmpty()) continue;
                return urls;
            }
            if (!isHtmlOrXml) {
                return Collections.emptyList();
            }
        }
        return (file2 = request.getVirtualFile()) instanceof LightVirtualFile || !request.getFile().getViewProvider().isPhysical() ? Collections.emptyList() : Collections.singletonList(Urls.newFromVirtualFile(file2));
    }

    @NotNull
    private static Collection<Url> getUrls(@Nullable WebBrowserUrlProvider provider, @NotNull OpenInBrowserRequest request) throws WebBrowserUrlProvider.BrowserException {
        block4: {
            if (provider != null) {
                if (request.getResult() != null) {
                    return request.getResult();
                }
                try {
                    return provider.getUrls(request);
                }
                catch (WebBrowserUrlProvider.BrowserException e) {
                    if (HtmlUtil.isHtmlFile((PsiElement)request.getFile())) break block4;
                    throw e;
                }
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public static WebBrowserUrlProvider getProvider(@NotNull OpenInBrowserRequest request) {
        DumbService dumbService = DumbService.getInstance((Project)request.getProject());
        for (WebBrowserUrlProvider urlProvider : (WebBrowserUrlProvider[])WebBrowserUrlProvider.EP_NAME.getExtensions()) {
            if (dumbService.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request)) continue;
            return urlProvider;
        }
        return null;
    }

    @NotNull
    public static Collection<Url> getDebuggableUrls(@Nullable PsiElement context) {
        try {
            OpenInBrowserRequest request;
            OpenInBrowserRequest openInBrowserRequest = request = context == null ? null : OpenInBrowserRequest.create((PsiElement)context);
            if (request == null || request.getFile().getViewProvider().getBaseLanguage() == XMLLanguage.INSTANCE) {
                return Collections.emptyList();
            }
            request.setAppendAccessToken(false);
            return WebBrowserServiceImpl.getUrls(WebBrowserServiceImpl.getProvider(request), request);
        }
        catch (WebBrowserUrlProvider.BrowserException ignored) {
            return Collections.emptyList();
        }
    }

    @Nullable
    public static Url getDebuggableUrl(@Nullable PsiElement context) {
        return (Url)ContainerUtil.getFirstItem(WebBrowserServiceImpl.getDebuggableUrls(context));
    }
}

