/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.PlatformIcons;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OpenUrlHyperlinkInfo
implements HyperlinkWithPopupMenuInfo {
    private final String url;
    private final WebBrowser browser;
    private final Condition<WebBrowser> browserCondition;

    public OpenUrlHyperlinkInfo(@NotNull String url) {
        this(url, (Condition<WebBrowser>)Conditions.alwaysTrue(), null);
    }

    public OpenUrlHyperlinkInfo(@NotNull String url, @Nullable WebBrowser browser) {
        this(url, (Condition<WebBrowser>)(browser == null ? Conditions.alwaysTrue() : Conditions.is((Object)browser)));
    }

    public OpenUrlHyperlinkInfo(@NotNull String url, @NotNull Condition<WebBrowser> browserCondition) {
        this(url, browserCondition, null);
    }

    private OpenUrlHyperlinkInfo(@NotNull String url, @NotNull Condition<WebBrowser> browserCondition, @Nullable WebBrowser browser) {
        this.url = url;
        this.browserCondition = browserCondition;
        this.browser = browser;
    }

    @Override
    public ActionGroup getPopupMenuGroup(@NotNull MouseEvent event) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (final WebBrowser browser : WebBrowserManager.getInstance().getActiveBrowsers()) {
            if (!this.browserCondition.value((Object)browser)) continue;
            group.add(new AnAction("Open in " + browser.getName(), "Open URL in " + browser.getName(), browser.getIcon()){

                public void actionPerformed(AnActionEvent e) {
                    BrowserLauncher.getInstance().browse(OpenUrlHyperlinkInfo.this.url, browser, e.getProject());
                }
            });
        }
        group.add(new AnAction("Copy URL", "Copy URL to clipboard", PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(OpenUrlHyperlinkInfo.this.url));
            }
        });
        return group;
    }

    public void navigate(Project project2) {
        BrowserLauncher.getInstance().browse(this.url, this.browser, project2);
    }
}

