/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaScriptDebuggerStarter<RC extends RunConfiguration, U> {
    public boolean isApplicable(@NotNull RunConfiguration var1);

    public void start(@NotNull String var1, @NotNull RC var2, @NotNull U var3, @Nullable WebBrowser var4);

    public static final class Util {
        static final ExtensionPointName<JavaScriptDebuggerStarter> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.javaScriptDebuggerStarter");
        private static final Object NULL_OBJECT = new Object();

        @Nullable
        public static <RC extends RunConfiguration, T> JavaScriptDebuggerStarter<RC, T> get(@NotNull RC runConfiguration) {
            for (JavaScriptDebuggerStarter starter : (JavaScriptDebuggerStarter[])EP_NAME.getExtensions()) {
                if (!starter.isApplicable(runConfiguration)) continue;
                return starter;
            }
            return null;
        }

        public static <RC extends RunConfiguration> boolean start(@NotNull RC runConfiguration, @NotNull String url) {
            return Util.start(runConfiguration, url, null);
        }

        public static <RC extends RunConfiguration> boolean start(@NotNull RC runConfiguration, @NotNull String url, @Nullable WebBrowser browser) {
            JavaScriptDebuggerStarter starter = Util.get(runConfiguration);
            if (starter == null) {
                return false;
            }
            starter.start(url, runConfiguration, NULL_OBJECT, browser);
            return true;
        }

        public static <RC extends RunConfiguration> void startDebugOrLaunchBrowser(@NotNull RC runConfiguration, @NotNull StartBrowserSettings settings) {
            String url = settings.getUrl();
            assert (url != null);
            Util.startDebugOrLaunchBrowser(runConfiguration, url, settings.getBrowser(), settings.isStartJavaScriptDebugger());
        }

        public static <RC extends RunConfiguration> void startDebugOrLaunchBrowser(@NotNull RC runConfiguration, @NotNull String url, @Nullable WebBrowser browser, boolean startDebugger) {
            if (!startDebugger || !Util.start(runConfiguration, url, browser)) {
                BrowserLauncher.getInstance().browse(url, browser, runConfiguration.getProject());
            }
        }

        public static boolean hasStarters() {
            return ((JavaScriptDebuggerStarter[])EP_NAME.getExtensions()).length > 0;
        }
    }
}

