/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.awt.EventQueue;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BookmarkManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class BookmarkManager
extends AbstractProjectComponent
implements PersistentStateComponent<Element> {
    private static final int MAX_AUTO_DESCRIPTION_SIZE = 50;
    private final List<Bookmark> myBookmarks = new ArrayList<Bookmark>();
    private final Map<Trinity<VirtualFile, Integer, String>, Bookmark> myDeletedDocumentBookmarks = new HashMap<Trinity<VirtualFile, Integer, String>, Bookmark>();
    private final MessageBus myBus;
    private boolean mySortedState;

    public static BookmarkManager getInstance(Project project2) {
        return (BookmarkManager)((Object)project2.getComponent(BookmarkManager.class));
    }

    public BookmarkManager(Project project2, MessageBus bus, PsiDocumentManager documentManager, EditorColorsManager colorsManager, EditorFactory editorFactory) {
        super(project2);
        colorsManager.addEditorColorsListener(new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                BookmarkManager.this.colorsChanged();
            }
        }, (Disposable)project2);
        this.myBus = bus;
        EditorEventMulticaster multicaster = editorFactory.getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this.myProject);
        multicaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)this.myProject);
        documentManager.addListener(new PsiDocumentManager.Listener(){

            public void documentCreated(final @NotNull Document document, PsiFile psiFile) {
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
                if (file2 == null) {
                    return;
                }
                for (final Bookmark bookmark : BookmarkManager.this.myBookmarks) {
                    if (!Comparing.equal((Object)bookmark.getFile(), (Object)file2)) continue;
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (BookmarkManager.this.myProject.isDisposed()) {
                                return;
                            }
                            bookmark.createHighlighter((MarkupModelEx)DocumentMarkupModel.forDocument(document, BookmarkManager.this.myProject, true));
                        }
                    });
                }
            }

            public void fileCreated(@NotNull PsiFile file2, @NotNull Document document) {
            }
        });
        this.mySortedState = UISettings.getInstance().SORT_BOOKMARKS;
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                if (BookmarkManager.this.mySortedState != UISettings.getInstance().SORT_BOOKMARKS) {
                    BookmarkManager.this.mySortedState = UISettings.getInstance().SORT_BOOKMARKS;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((BookmarksListener)BookmarkManager.this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarksOrderChanged();
                        }
                    });
                }
            }
        }, (Disposable)project2);
    }

    public void editDescription(@NotNull Bookmark bookmark) {
        String description = Messages.showInputDialog((Project)this.myProject, (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)bookmark.getDescription(), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        if (description != null) {
            this.setDescription(bookmark, description);
        }
    }

    @NotNull
    public String getComponentName() {
        return "BookmarkManager";
    }

    public void addEditorBookmark(@NotNull Editor editor, int lineIndex) {
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addTextBookmark(virtualFile, lineIndex, BookmarkManager.getAutoDescription(editor, lineIndex));
    }

    @NotNull
    public Bookmark addTextBookmark(@NotNull VirtualFile file2, int lineIndex, @NotNull String description) {
        Bookmark b = new Bookmark(this.myProject, file2, lineIndex, description);
        this.myBookmarks.add(0, b);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkAdded(b);
        return b;
    }

    @NotNull
    public static String getAutoDescription(@NotNull Editor editor, int lineIndex) {
        String autoDescription = editor.getSelectionModel().getSelectedText();
        if (autoDescription == null) {
            Document document = editor.getDocument();
            autoDescription = document.getCharsSequence().subSequence(document.getLineStartOffset(lineIndex), document.getLineEndOffset(lineIndex)).toString().trim();
        }
        if (autoDescription.length() > 50) {
            return autoDescription.substring(0, 50) + "...";
        }
        return autoDescription;
    }

    @Nullable
    public Bookmark addFileBookmark(@Nullable VirtualFile file2, @NotNull String description) {
        if (file2 == null) {
            return null;
        }
        if (this.findFileBookmark(file2) != null) {
            return null;
        }
        Bookmark b = new Bookmark(this.myProject, file2, -1, description);
        this.myBookmarks.add(0, b);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkAdded(b);
        return b;
    }

    @NotNull
    public List<Bookmark> getValidBookmarks() {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (Bookmark bookmark : this.myBookmarks) {
            if (!bookmark.isValid()) continue;
            answer.add(bookmark);
        }
        if (UISettings.getInstance().SORT_BOOKMARKS) {
            Collections.sort(answer);
        }
        return answer;
    }

    @Nullable
    public Bookmark findEditorBookmark(@NotNull Document document, int line) {
        for (Bookmark bookmark : this.myBookmarks) {
            if (bookmark.getDocument() != document || bookmark.getLine() != line) continue;
            return bookmark;
        }
        return null;
    }

    @Nullable
    public Bookmark findFileBookmark(@NotNull VirtualFile file2) {
        for (Bookmark bookmark : this.myBookmarks) {
            if (!Comparing.equal((Object)bookmark.getFile(), (Object)file2) || bookmark.getLine() != -1) continue;
            return bookmark;
        }
        return null;
    }

    @Nullable
    public Bookmark findBookmarkForMnemonic(char m) {
        char mm = Character.toUpperCase(m);
        for (Bookmark bookmark : this.myBookmarks) {
            if (mm != bookmark.getMnemonic()) continue;
            return bookmark;
        }
        return null;
    }

    public boolean hasBookmarksWithMnemonics() {
        for (Bookmark bookmark : this.myBookmarks) {
            if (bookmark.getMnemonic() == '\u0000') continue;
            return true;
        }
        return false;
    }

    public void removeBookmark(@NotNull Bookmark bookmark) {
        if (this.myBookmarks.remove(bookmark)) {
            bookmark.release();
            ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkRemoved(bookmark);
        }
    }

    public Element getState() {
        Element container = new Element("BookmarkManager");
        this.writeExternal(container);
        return container;
    }

    public void loadState(final Element state) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                BookmarksListener publisher = (BookmarksListener)BookmarkManager.this.myBus.syncPublisher(BookmarksListener.TOPIC);
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks) {
                    bookmark.release();
                    publisher.bookmarkRemoved(bookmark);
                }
                BookmarkManager.this.myBookmarks.clear();
                BookmarkManager.this.readExternal(state);
            }
        });
    }

    private void readExternal(Element element) {
        for (Object o : element.getChildren()) {
            Element bookmarkElement = (Element)o;
            if (!"bookmark".equals(bookmarkElement.getName())) continue;
            String url = bookmarkElement.getAttributeValue("url");
            String line = bookmarkElement.getAttributeValue("line");
            String description = StringUtil.notNullize((String)bookmarkElement.getAttributeValue("description"));
            String mnemonic = bookmarkElement.getAttributeValue("mnemonic");
            Bookmark b = null;
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file2 != null) {
                if (line != null) {
                    try {
                        int lineIndex = Integer.parseInt(line);
                        b = this.addTextBookmark(file2, lineIndex, description);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    b = this.addFileBookmark(file2, description);
                }
            }
            if (b == null || mnemonic == null || mnemonic.length() != 1) continue;
            this.setMnemonic(b, mnemonic.charAt(0));
        }
    }

    private void writeExternal(Element element) {
        ArrayList<Bookmark> reversed = new ArrayList<Bookmark>(this.myBookmarks);
        Collections.reverse(reversed);
        for (Bookmark bookmark : reversed) {
            char mnemonic;
            int line;
            if (!bookmark.isValid()) continue;
            Element bookmarkElement = new Element("bookmark");
            bookmarkElement.setAttribute("url", bookmark.getFile().getUrl());
            String description = bookmark.getNotEmptyDescription();
            if (description != null) {
                bookmarkElement.setAttribute("description", description);
            }
            if ((line = bookmark.getLine()) >= 0) {
                bookmarkElement.setAttribute("line", String.valueOf(line));
            }
            if ((mnemonic = bookmark.getMnemonic()) != '\u0000') {
                bookmarkElement.setAttribute("mnemonic", String.valueOf(mnemonic));
            }
            element.addContent(bookmarkElement);
        }
    }

    @NotNull
    public List<Bookmark> moveBookmarkUp(@NotNull Bookmark bookmark) {
        final int index = this.myBookmarks.indexOf(bookmark);
        if (index > 0) {
            Collections.swap(this.myBookmarks, index, index - 1);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((BookmarksListener)BookmarkManager.this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged((Bookmark)BookmarkManager.this.myBookmarks.get(index));
                    ((BookmarksListener)BookmarkManager.this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged((Bookmark)BookmarkManager.this.myBookmarks.get(index - 1));
                }
            });
        }
        return this.myBookmarks;
    }

    @NotNull
    public List<Bookmark> moveBookmarkDown(@NotNull Bookmark bookmark) {
        final int index = this.myBookmarks.indexOf(bookmark);
        if (index < this.myBookmarks.size() - 1) {
            Collections.swap(this.myBookmarks, index, index + 1);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((BookmarksListener)BookmarkManager.this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged((Bookmark)BookmarkManager.this.myBookmarks.get(index));
                    ((BookmarksListener)BookmarkManager.this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged((Bookmark)BookmarkManager.this.myBookmarks.get(index + 1));
                }
            });
        }
        return this.myBookmarks;
    }

    @Nullable
    public Bookmark getNextBookmark(@NotNull Editor editor, boolean isWrapped) {
        Bookmark[] bookmarksForDocument = this.getBookmarksForDocument(editor.getDocument());
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        for (Bookmark bookmark : bookmarksForDocument) {
            if (bookmark.getLine() <= lineNumber) continue;
            return bookmark;
        }
        if (isWrapped && bookmarksForDocument.length > 0) {
            return bookmarksForDocument[0];
        }
        return null;
    }

    @Nullable
    public Bookmark getPreviousBookmark(@NotNull Editor editor, boolean isWrapped) {
        Bookmark[] bookmarksForDocument = this.getBookmarksForDocument(editor.getDocument());
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        for (int i = bookmarksForDocument.length - 1; i >= 0; --i) {
            Bookmark bookmark = bookmarksForDocument[i];
            if (bookmark.getLine() >= lineNumber) continue;
            return bookmark;
        }
        if (isWrapped && bookmarksForDocument.length > 0) {
            return bookmarksForDocument[bookmarksForDocument.length - 1];
        }
        return null;
    }

    @NotNull
    private Bookmark[] getBookmarksForDocument(@NotNull Document document) {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (Bookmark bookmark : this.getValidBookmarks()) {
            if (!document.equals(bookmark.getDocument())) continue;
            answer.add(bookmark);
        }
        Bookmark[] bookmarks = answer.toArray(new Bookmark[answer.size()]);
        Arrays.sort(bookmarks, new Comparator<Bookmark>(){

            @Override
            public int compare(Bookmark o1, Bookmark o2) {
                return o1.getLine() - o2.getLine();
            }
        });
        return bookmarks;
    }

    public void setMnemonic(@NotNull Bookmark bookmark, char c) {
        Bookmark old = this.findBookmarkForMnemonic(c);
        if (old != null) {
            this.removeBookmark(old);
        }
        bookmark.setMnemonic(c);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    public void setDescription(@NotNull Bookmark bookmark, String description) {
        bookmark.setDescription(description);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    public void colorsChanged() {
        for (Bookmark bookmark : this.myBookmarks) {
            bookmark.updateHighlighter();
        }
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            if (e.isWholeTextReplaced()) {
                return;
            }
            HashMap<Trinity, Bookmark> bookmarksToRemove = null;
            for (Bookmark bookmark : BookmarkManager.this.myBookmarks) {
                Document document = bookmark.getDocument();
                if (document == null || document != e.getDocument() || bookmark.getLine() == -1) continue;
                int start = document.getLineStartOffset(bookmark.getLine());
                int end = document.getLineEndOffset(bookmark.getLine());
                if (start < e.getOffset() || end > e.getOffset() + e.getOldLength()) continue;
                Trinity restoreBookmarkData = new Trinity((Object)bookmark.getFile(), (Object)bookmark.getLine(), (Object)document.getText(new TextRange(start, end)));
                if (bookmarksToRemove == null) {
                    bookmarksToRemove = new HashMap<Trinity, Bookmark>();
                }
                bookmarksToRemove.put(restoreBookmarkData, bookmark);
            }
            if (bookmarksToRemove != null) {
                for (Map.Entry entry : bookmarksToRemove.entrySet()) {
                    BookmarkManager.this.removeBookmark((Bookmark)entry.getValue());
                    BookmarkManager.this.myDeletedDocumentBookmarks.put(entry.getKey(), entry.getValue());
                }
            }
        }

        private boolean isDuplicate(Bookmark bookmark, @Nullable List<Bookmark> toRemove) {
            for (Bookmark b : BookmarkManager.this.myBookmarks) {
                if (b == bookmark || !b.isValid() || !Comparing.equal((Object)b.getFile(), (Object)bookmark.getFile()) || b.getLine() != bookmark.getLine() || toRemove != null && toRemove.contains(b)) continue;
                return true;
            }
            return false;
        }

        public void documentChanged(DocumentEvent e) {
            ArrayList<Bookmark> bookmarksToRemove = null;
            for (Bookmark bookmark : BookmarkManager.this.myBookmarks) {
                if (bookmark.isValid() && !this.isDuplicate(bookmark, (List<Bookmark>)bookmarksToRemove)) continue;
                if (bookmarksToRemove == null) {
                    bookmarksToRemove = new ArrayList<Bookmark>();
                }
                bookmarksToRemove.add(bookmark);
            }
            if (bookmarksToRemove != null) {
                for (Bookmark bookmark : bookmarksToRemove) {
                    BookmarkManager.this.removeBookmark(bookmark);
                }
            }
            Iterator iterator = BookmarkManager.this.myDeletedDocumentBookmarks.entrySet().iterator();
            while (iterator.hasNext()) {
                int end;
                int start;
                String lineContent;
                Map.Entry entry = iterator.next();
                if (!((VirtualFile)((Trinity)entry.getKey()).first).isValid()) {
                    iterator.remove();
                    continue;
                }
                Bookmark bookmark = (Bookmark)entry.getValue();
                Document document = bookmark.getDocument();
                if (document == null || !bookmark.getFile().equals(((Trinity)entry.getKey()).first)) continue;
                Integer line = (Integer)((Trinity)entry.getKey()).second;
                if (document.getLineCount() <= line || !((String)((Trinity)entry.getKey()).third).equals(lineContent = document.getText(new TextRange(start = document.getLineStartOffset(line.intValue()), end = document.getLineEndOffset(line.intValue()))))) continue;
                Bookmark restored = BookmarkManager.this.addTextBookmark(bookmark.getFile(), bookmark.getLine(), bookmark.getDescription());
                if (bookmark.getMnemonic() != '\u0000') {
                    BookmarkManager.this.setMnemonic(restored, bookmark.getMnemonic());
                }
                iterator.remove();
            }
        }
    }

    private class MyEditorMouseListener
    extends EditorMouseAdapter {
        private MyEditorMouseListener() {
        }

        public void mouseClicked(EditorMouseEvent e) {
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA) {
                return;
            }
            if (e.getMouseEvent().isPopupTrigger()) {
                return;
            }
            if ((e.getMouseEvent().getModifiers() & (SystemInfo.isMac ? 4 : 2)) == 0) {
                return;
            }
            Editor editor = e.getEditor();
            int line = editor.xyToLogicalPosition((Point)new Point((int)e.getMouseEvent().getX(), (int)e.getMouseEvent().getY())).line;
            if (line < 0) {
                return;
            }
            Document document = editor.getDocument();
            Bookmark bookmark = BookmarkManager.this.findEditorBookmark(document, line);
            if (bookmark == null) {
                BookmarkManager.this.addEditorBookmark(editor, line);
            } else {
                BookmarkManager.this.removeBookmark(bookmark);
            }
            e.consume();
        }
    }
}

