/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final ToolWindow myToolWindow;

    @NotNull
    public static ActionGroup createToggleToolbarGroup(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        return new DefaultActionGroup(new AnAction[]{new OptionsGroup(toolWindow), new ToggleToolbarAction(toolWindow, PropertiesComponent.getInstance((Project)project2)), Separator.getInstance()});
    }

    private ToggleToolbarAction(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent propertiesComponent) {
        super("Show Toolbar");
        this.myPropertiesComponent = propertiesComponent;
        this.myToolWindow = toolWindow;
        this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                ContentManager contentManager;
                JComponent component = event.getContent().getComponent();
                ToggleToolbarAction.setContentToolbarVisible(component, ToggleToolbarAction.this.getVisibilityValue());
                ContentManager contentManager2 = contentManager = component instanceof DataProvider ? (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData((DataProvider)component) : null;
                if (contentManager != null) {
                    contentManager.addContentManagerListener((ContentManagerListener)this);
                }
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars(this.myToolWindow.getContentManager().getComponent()).iterator().hasNext();
        e.getPresentation().setVisible(hasToolbars);
    }

    public boolean isSelected(AnActionEvent e) {
        return this.getVisibilityValue();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        this.myPropertiesComponent.setValue(this.getProperty(), String.valueOf(state), String.valueOf(true));
        for (Content content : this.myToolWindow.getContentManager().getContents()) {
            ToggleToolbarAction.setContentToolbarVisible(content.getComponent(), state);
        }
    }

    @NotNull
    private String getProperty() {
        return ToggleToolbarAction.getShowToolbarProperty(this.myToolWindow);
    }

    private boolean getVisibilityValue() {
        return this.myPropertiesComponent.getBoolean(this.getProperty(), true);
    }

    private static void setContentToolbarVisible(@NotNull JComponent root, boolean state) {
        for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(root)) {
            toolbar.getComponent().setVisible(state);
        }
    }

    @NotNull
    public static String getShowToolbarProperty(@NotNull ToolWindow window) {
        return "ToolWindow" + window.getStripeTitle() + ".ShowToolbar";
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(JComponent root) {
        return ((JBTreeTraverser)UIUtil.uiTraverser().withRoot((Object)root)).preOrderDfsTraversal().filter(ActionToolbar.class);
    }

    private static class OptionsGroup
    extends ActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        public OptionsGroup(ToolWindow toolWindow) {
            super("View Options", true);
            this.myToolWindow = toolWindow;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(!ActionGroupUtil.isGroupEmpty((ActionGroup)this, (AnActionEvent)e));
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            JComponent contentComponent;
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content selectedContent = contentManager.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent != null ? selectedContent.getComponent() : null;
            if (contentComponent == null) {
                return EMPTY_ARRAY;
            }
            List result = ContainerUtil.newSmartList();
            for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(contentComponent)) {
                JComponent c = toolbar.getComponent();
                if (c.isVisible() || !c.isValid()) continue;
                if (!result.isEmpty() && !(ContainerUtil.getLastItem((List)result) instanceof Separator)) {
                    result.add(Separator.getInstance());
                }
                List actions = toolbar.getActions(false);
                for (AnAction action : actions) {
                    if (action instanceof ToggleAction && !result.contains(action)) {
                        result.add(action);
                        continue;
                    }
                    if (!(action instanceof Separator) || result.isEmpty() || ContainerUtil.getLastItem((List)result) instanceof Separator) continue;
                    result.add(Separator.getInstance());
                }
            }
            boolean popup = result.size() > 3;
            this.setPopup(popup);
            if (!popup && !result.isEmpty()) {
                result.add(Separator.getInstance());
            }
            return result.toArray(new AnAction[result.size()]);
        }
    }
}

