/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;

public class TogglePopupHintsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.TogglePopupHintsAction");

    private static PsiFile getTargetFile(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        VirtualFile[] files = FileEditorManager.getInstance((Project)project2).getSelectedFiles();
        if (files.length == 0) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(files[0]);
        LOG.assertTrue(psiFile != null);
        return psiFile;
    }

    public void update(AnActionEvent e) {
        PsiFile psiFile = TogglePopupHintsAction.getTargetFile(e.getDataContext());
        e.getPresentation().setEnabled(psiFile != null);
    }

    public void actionPerformed(AnActionEvent e) {
        PsiFile psiFile = TogglePopupHintsAction.getTargetFile(e.getDataContext());
        LOG.assertTrue(psiFile != null);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        LOG.assertTrue(project2 != null);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
        codeAnalyzer.setImportHintsEnabled(psiFile, !codeAnalyzer.isImportHintsEnabled(psiFile));
        DaemonListeners.getInstance(project2).updateStatusBar();
    }
}

