/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickChangeInspectionProfileAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfile current = projectProfileManager.getInspectionProfile();
        for (Profile profile : projectProfileManager.getProfiles()) {
            QuickChangeInspectionProfileAction.addScheme(group, projectProfileManager, (Profile)current, profile);
        }
    }

    private static void addScheme(DefaultActionGroup group, final InspectionProjectProfileManager projectProfileManager, Profile current, final Profile scheme) {
        group.add((AnAction)new DumbAwareAction(scheme.getName(), "", scheme == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@Nullable AnActionEvent e) {
                projectProfileManager.setProjectProfile(scheme.getName());
            }
        });
    }

    protected boolean isEnabled() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2 = QuickChangeInspectionProfileAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible(project2 != null && InspectionProjectProfileManager.getInstance(project2).getProfiles().size() > 1);
    }
}

