/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        EditorColorsScheme current = EditorColorsManager.getInstance().getGlobalScheme();
        for (EditorColorsScheme scheme : EditorColorsManager.getInstance().getAllSchemes()) {
            QuickChangeColorSchemeAction.addScheme(group, current, scheme, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, EditorColorsScheme current, final EditorColorsScheme scheme, final boolean addScheme) {
        group.add((AnAction)new DumbAwareAction(scheme.getName(), "", scheme == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@Nullable AnActionEvent e) {
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorsScheme(scheme);
                }
                EditorColorsManager.getInstance().setGlobalScheme(scheme);
            }
        });
    }

    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1;
    }
}

