/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeCodeStyleSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        final CodeStyleSettingsManager manager = CodeStyleSettingsManager.getInstance((Project)project2);
        if (manager.PER_PROJECT_SETTINGS != null) {
            group.add(new AnAction("<project>", "", manager.USE_PER_PROJECT_SETTINGS ? ourCurrentAction : ourNotCurrentAction){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    manager.USE_PER_PROJECT_SETTINGS = true;
                }
            });
        }
        CodeStyleScheme currentScheme = CodeStyleSchemes.getInstance().getCurrentScheme();
        for (CodeStyleScheme scheme : CodeStyleSchemes.getInstance().getSchemes()) {
            QuickChangeCodeStyleSchemeAction.addScheme(group, manager, currentScheme, scheme, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, final CodeStyleSettingsManager manager, CodeStyleScheme currentScheme, final CodeStyleScheme scheme, final boolean addScheme) {
        group.add((AnAction)new DumbAwareAction(scheme.getName(), "", scheme == currentScheme && !manager.USE_PER_PROJECT_SETTINGS ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (addScheme) {
                    CodeStyleSchemes.getInstance().addScheme(scheme);
                }
                CodeStyleSchemes.getInstance().setCurrentScheme(scheme);
                manager.USE_PER_PROJECT_SETTINGS = false;
                manager.PREFERRED_PROJECT_CODE_STYLE = scheme.getName();
                EditorFactory.getInstance().refreshAllEditors();
            }
        });
    }

    protected boolean isEnabled() {
        return CodeStyleSchemes.getInstance().getSchemes().length > 1;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(CommonDataKeys.PROJECT.getData(e.getDataContext()) != null);
    }
}

