/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleAction
extends AnAction {
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";

    public void actionPerformed(AnActionEvent e) {
        ImportModuleAction.doImport(ImportModuleAction.getEventProject((AnActionEvent)e));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(ImportModuleAction.getEventProject((AnActionEvent)e) != null);
    }

    public boolean isDumbAware() {
        return true;
    }

    public static List<Module> doImport(@Nullable Project project2) {
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project2, null);
        if (wizard == null || wizard.getStepCount() > 0 && !wizard.showAndGet()) {
            return Collections.emptyList();
        }
        return ImportModuleAction.createFromWizard(project2, wizard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Module> createFromWizard(@Nullable Project project2, AbstractProjectWizard wizard) {
        if (project2 == null) {
            Project newProject = NewProjectUtil.createFromWizard(wizard, null);
            return newProject == null ? Collections.emptyList() : Arrays.asList(ModuleManager.getInstance((Project)newProject).getModules());
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        try {
            if (wizard.getStepCount() > 0) {
                Module module2 = new NewModuleAction().createModuleFromWizard(project2, null, wizard);
                List<Module> list = Collections.singletonList(module2);
                return list;
            }
            List list = projectBuilder.commit(project2);
            return list;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project2, @Nullable Component dialogParent) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Select File or Directory to Import");
        List<ProjectImportProvider> providers = ImportModuleAction.getProviders(project2);
        String description = ImportModuleAction.getFileChooserDescription(providers);
        descriptor.setDescription(description);
        return ImportModuleAction.selectFileAndCreateWizard(project2, dialogParent, descriptor, (ProjectImportProvider[])ArrayUtil.toObjectArray(providers, ProjectImportProvider.class));
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project2, @Nullable Component dialogParent, @NotNull FileChooserDescriptor descriptor, ProjectImportProvider[] providers) {
        VirtualFile[] files;
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project2, dialogParent);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(project2, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file2 = files[0];
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file2.getPath());
        return ImportModuleAction.createImportWizard(project2, dialogParent, file2, providers);
    }

    public static String getFileChooserDescription(@Nullable Project project2) {
        return ImportModuleAction.getFileChooserDescription(ImportModuleAction.getProviders(project2));
    }

    private static String getFileChooserDescription(List<ProjectImportProvider> providers) {
        StringBuilder builder = new StringBuilder("<html>Select ");
        boolean first = true;
        if (providers.size() > 0) {
            for (ProjectImportProvider provider : providers) {
                String sample = provider.getFileSample();
                if (sample == null) continue;
                if (!first) {
                    builder.append(", <br>");
                } else {
                    first = false;
                }
                builder.append(sample);
            }
        }
        builder.append(".</html>");
        return builder.toString();
    }

    @NotNull
    public static List<ProjectImportProvider> getProviders(final @Nullable Project project2) {
        Object[] providers = (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions();
        return ContainerUtil.filter((Object[])providers, (Condition)new Condition<ProjectImportProvider>(){

            public boolean value(ProjectImportProvider provider) {
                return project2 == null ? provider.canCreateNewProject() : provider.canImportModule();
            }
        });
    }

    @Nullable
    public static AddModuleWizard createImportWizard(final @Nullable Project project2, @Nullable Component dialogParent, final @NotNull VirtualFile file2, ProjectImportProvider ... providers) {
        List available = ContainerUtil.filter((Object[])providers, (Condition)new Condition<ProjectImportProvider>(){

            public boolean value(ProjectImportProvider provider) {
                return provider.canImport(file2, project2);
            }
        });
        if (available.isEmpty()) {
            Messages.showInfoMessage((Project)project2, (String)("Cannot import anything from " + file2.getPath()), (String)"Cannot Import");
            return null;
        }
        String path = available.size() == 1 ? ((ProjectImportProvider)available.get(0)).getPathToBeImported(file2) : ProjectImportProvider.getDefaultPath(file2);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[available.size()]);
        return dialogParent == null ? new AddModuleWizard(project2, path, availableProviders) : new AddModuleWizard(project2, dialogParent, path, availableProviders);
    }
}

