/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private final Project myProject;
    private final GotoFileModel myModel;

    public GotoFileItemProvider(@NotNull Project project2, @Nullable PsiElement context, GotoFileModel model) {
        super(context);
        this.myProject = project2;
        this.myModel = model;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        if (pattern.contains("/") || pattern.contains("\\")) {
            ProjectFileIndex index;
            String path = FileUtil.toSystemIndependentName((String)ChooseByNamePopup.getTransformedPattern(pattern, this.myModel));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPathIfCached(path);
            if (vFile != null && ((index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject)).isInContent(vFile) || index.isInLibraryClasses(vFile) || index.isInLibrarySource(vFile))) {
                PsiDirectory fileOrDir;
                Object object = fileOrDir = vFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)this.myProject).findFile(vFile);
                if (fileOrDir != null && !consumer.process((Object)fileOrDir)) {
                    return false;
                }
            }
        }
        return super.filterElements(base, pattern, everywhere, indicator, consumer);
    }
}

