/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathKt;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/ExportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "configuration-store-impl"})
final class ExportSettingsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@Nullable AnActionEvent e) {
        ApplicationManager.getApplication().saveSettings();
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(ExportSettingsActionKt.getExportableComponentsMap$default(true, true, null, null, 12, null), true, IdeBundle.message((String)"title.select.components.to.export", (Object[])new Object[0]), IdeBundle.message((String)"prompt.please.check.all.components.to.export", (Object[])new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        Set<ExportableItem> markedComponents = dialog.getExportableComponents();
        if (markedComponents.isEmpty()) {
            return;
        }
        THashSet exportFiles = new THashSet();
        for (ExportableItem markedComponent : markedComponents) {
            exportFiles.addAll((Collection)markedComponent.getFiles());
        }
        Path saveFile = dialog.getExportFile();
        try {
            if (PathKt.exists(saveFile) && Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.overwrite.settings.file", (Object[])new Object[]{((Object)saveFile).toString()}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            Set set = (Set)exportFiles;
            OutputStream outputStream = PathKt.outputStream(saveFile);
            String string = FileUtilRt.toSystemIndependentName((String)PathManager.getConfigPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.toSystemIndep\u2026hManager.getConfigPath())");
            ExportSettingsActionKt.exportSettings(set, outputStream, string);
            ShowFilePathAction.showDialog(AnAction.getEventProject((AnActionEvent)e), IdeBundle.message((String)"message.settings.exported.successfully", (Object[])new Object[0]), IdeBundle.message((String)"title.export.successful", (Object[])new Object[0]), saveFile.toFile(), null);
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.writing.settings", (Object[])new Object[]{e1.toString()}), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }
}

