/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateAction<T extends PsiElement>
extends AnAction {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.CreateFromTemplateAction");

    public CreateFromTemplateAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project2 == null) {
            return;
        }
        CreateFileFromTemplateDialog.Builder builder = CreateFileFromTemplateDialog.createDialog(project2);
        this.buildDialog(project2, dir, builder);
        final Ref selectedTemplateName = Ref.create(null);
        Object createdElement = builder.show(this.getErrorTitle(), this.getDefaultTemplateName(dir), new CreateFileFromTemplateDialog.FileCreator<T>(){

            @Override
            public T createFile(@NotNull String name, @NotNull String templateName) {
                selectedTemplateName.set((Object)templateName);
                return CreateFromTemplateAction.this.createFile(name, templateName, dir);
            }

            @Override
            @NotNull
            public String getActionName(@NotNull String name, @NotNull String templateName) {
                return CreateFromTemplateAction.this.getActionName(dir, name, templateName);
            }
        });
        if (createdElement != null) {
            view.selectElement(createdElement);
            this.postProcess(createdElement, (String)selectedTemplateName.get(), builder.getCustomProperties());
        }
    }

    protected void postProcess(T createdElement, String templateName, Map<String, String> customProperties) {
    }

    @Nullable
    protected abstract T createFile(String var1, String var2, PsiDirectory var3);

    protected abstract void buildDialog(Project var1, PsiDirectory var2, CreateFileFromTemplateDialog.Builder var3);

    @Nullable
    protected String getDefaultTemplateName(@NotNull PsiDirectory dir) {
        String property = this.getDefaultTemplateProperty();
        return property == null ? null : PropertiesComponent.getInstance((Project)dir.getProject()).getValue(property);
    }

    @Nullable
    protected String getDefaultTemplateProperty() {
        return null;
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return project2 != null && view != null && view.getDirectories().length != 0;
    }

    protected abstract String getActionName(PsiDirectory var1, String var2, String var3);

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    public static void moveCaretAfterNameIdentifier(PsiNameIdentifierOwner createdElement) {
        PsiElement nameIdentifier;
        VirtualFile virtualFile;
        Project project2 = createdElement.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor != null && (virtualFile = createdElement.getContainingFile().getVirtualFile()) != null && FileDocumentManager.getInstance().getDocument(virtualFile) == editor.getDocument() && (nameIdentifier = createdElement.getNameIdentifier()) != null) {
            editor.getCaretModel().moveToOffset(nameIdentifier.getTextRange().getEndOffset());
        }
    }
}

