/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.AboutAction;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MacOSApplicationProvider
implements ApplicationComponent {
    private static final Callback IMPL = new Callback(){

        public void callback(ID self, String selector) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionManagerEx am = ActionManagerEx.getInstanceEx();
                    MouseEvent me = new MouseEvent(JOptionPane.getRootFrame(), 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
                    am.tryToExecute(am.getAction("CheckForUpdate"), (InputEvent)me, null, null, false);
                }
            });
        }
    };

    public MacOSApplicationProvider() {
        if (SystemInfo.isMac) {
            try {
                Worker.initMacApplication();
            }
            catch (Throwable t) {
                Logger.getInstance(MacOSApplicationProvider.class).warn(t);
            }
        }
    }

    @NotNull
    public String getComponentName() {
        return "MACOSApplicationProvider";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static class Worker {
        private Worker() {
        }

        public static void initMacApplication() {
            Application application = new Application();
            application.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                public void handleAbout(ApplicationEvent applicationEvent) {
                    AboutAction.showAbout();
                    applicationEvent.setHandled(true);
                }

                public void handlePreferences(ApplicationEvent applicationEvent) {
                    Project project2 = Worker.getProject();
                    if (project2 == null) {
                        project2 = ProjectManager.getInstance().getDefaultProject();
                    }
                    if (!((ShowSettingsUtilImpl)ShowSettingsUtil.getInstance()).isAlreadyShown()) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(project2, ShowSettingsUtilImpl.getConfigurableGroups(project2, true));
                    }
                    applicationEvent.setHandled(true);
                }

                public void handleQuit(ApplicationEvent applicationEvent) {
                    ApplicationManagerEx.getApplicationEx().exit();
                }

                public void handleOpenFile(ApplicationEvent applicationEvent) {
                    Project project2 = Worker.getProject();
                    String filename = applicationEvent.getFilename();
                    if (filename == null) {
                        return;
                    }
                    File file2 = new File(filename);
                    if (ProjectUtil.openOrImport(file2.getAbsolutePath(), project2, true) != null) {
                        IdeaApplication.getInstance().setPerformProjectLoad(false);
                        return;
                    }
                    if (project2 != null && file2.exists()) {
                        OpenFileAction.openFile(filename, project2);
                        applicationEvent.setHandled(true);
                    }
                }
            });
            application.addAboutMenuItem();
            application.addPreferencesMenuItem();
            application.setEnabledAboutMenu(true);
            application.setEnabledPreferencesMenu(true);
            Worker.installAutoUpdateMenu();
        }

        private static void installAutoUpdateMenu() {
            ID pool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
            ID app = Foundation.invoke((String)"NSApplication", (String)"sharedApplication", (Object[])new Object[0]);
            ID menu = Foundation.invoke((ID)app, (Pointer)Foundation.createSelector((String)"menu"), (Object[])new Object[0]);
            ID item = Foundation.invoke((ID)menu, (Pointer)Foundation.createSelector((String)"itemAtIndex:"), (Object[])new Object[]{0});
            ID appMenu = Foundation.invoke((ID)item, (Pointer)Foundation.createSelector((String)"submenu"), (Object[])new Object[0]);
            ID checkForUpdatesClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSMenuItem"), (String)"NSCheckForUpdates");
            Foundation.addMethod((ID)checkForUpdatesClass, (Pointer)Foundation.createSelector((String)"checkForUpdates"), (Callback)IMPL, (String)"v");
            Foundation.registerObjcClassPair((ID)checkForUpdatesClass);
            ID checkForUpdates = Foundation.invoke((String)"NSCheckForUpdates", (String)"alloc", (Object[])new Object[0]);
            Foundation.invoke((ID)checkForUpdates, (Pointer)Foundation.createSelector((String)"initWithTitle:action:keyEquivalent:"), (Object[])new Object[]{Foundation.nsString((String)"Check for Updates..."), Foundation.createSelector((String)"checkForUpdates"), Foundation.nsString((String)"")});
            Foundation.invoke((ID)checkForUpdates, (Pointer)Foundation.createSelector((String)"setTarget:"), (Object[])new Object[]{checkForUpdates});
            Foundation.invoke((ID)appMenu, (Pointer)Foundation.createSelector((String)"insertItem:atIndex:"), (Object[])new Object[]{checkForUpdates, 1});
            Foundation.invoke((ID)checkForUpdates, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
            Foundation.invoke((ID)pool, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
        }

        private static Project getProject() {
            return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        }
    }
}

