/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChangedNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(FileChangedNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.changed.notification.panel");
    private final Project myProject;

    public FileChangedNotificationProvider(@NotNull Project project2, @NotNull FrameStateManager frameStateManager) {
        this.myProject = project2;
        frameStateManager.addListener((FrameStateListener)new FrameStateListener.Adapter(){

            public void onFrameActivated() {
                if (!FileChangedNotificationProvider.this.myProject.isDisposed() && !GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)FileChangedNotificationProvider.this.myProject);
                    for (VirtualFile file2 : FileEditorManager.getInstance((Project)FileChangedNotificationProvider.this.myProject).getSelectedFiles()) {
                        notifications.updateNotifications(file2);
                    }
                }
            }
        }, (Disposable)project2);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (!FileChangedNotificationProvider.this.myProject.isDisposed() && !GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    HashSet openFiles = ContainerUtil.newHashSet((Object[])FileEditorManager.getInstance((Project)FileChangedNotificationProvider.this.myProject).getSelectedFiles());
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)FileChangedNotificationProvider.this.myProject);
                    for (VFileEvent vFileEvent : events) {
                        VirtualFile file2 = vFileEvent.getFile();
                        if (file2 == null || !openFiles.contains(file2)) continue;
                        notifications.updateNotifications(file2);
                    }
                }
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        FileAttributes attributes;
        VirtualFileSystem fs;
        if (!(this.myProject.isDisposed() || GeneralSettings.getInstance().isSyncOnFrameActivation() || !((fs = file2.getFileSystem()) instanceof LocalFileSystem) || (attributes = ((LocalFileSystem)fs).getAttributes(file2)) != null && file2.getTimeStamp() == attributes.lastModified && file2.getLength() == attributes.length)) {
            LogUtil.debug((Logger)LOG, (String)"%s: (%s,%s) -> %s", (Object[])new Object[]{file2, file2.getTimeStamp(), file2.getLength(), attributes});
            return this.createPanel(file2);
        }
        return null;
    }

    private EditorNotificationPanel createPanel(final @NotNull VirtualFile file2) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(IdeBundle.message((String)"file.changed.externally.message", (Object[])new Object[0]));
        panel.createActionLabel(IdeBundle.message((String)"file.changed.externally.reload", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                if (!FileChangedNotificationProvider.this.myProject.isDisposed()) {
                    file2.refresh(false, false);
                    EditorNotifications.getInstance((Project)FileChangedNotificationProvider.this.myProject).updateNotifications(file2);
                }
            }
        });
        return panel;
    }
}

