/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.FilesTooBigForDiffException;

public class SelectionDifferenceModel
extends FileDifferenceModel {
    private final SelectionCalculator myCalculator;
    private final Revision myLeftRevision;
    private final Revision myRightRevision;
    private final int myFrom;
    private final int myTo;

    public SelectionDifferenceModel(Project p, IdeaGateway gw, SelectionCalculator c, Revision left, Revision right, int from, int to, boolean editableRightContent) {
        super(p, gw, editableRightContent);
        this.myCalculator = c;
        this.myLeftRevision = left;
        this.myRightRevision = right;
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    protected Entry getLeftEntry() {
        return this.myLeftRevision.findEntry();
    }

    @Override
    protected Entry getRightEntry() {
        return this.myRightRevision.findEntry();
    }

    @Override
    protected boolean isLeftContentAvailable(RevisionProcessingProgress p) {
        try {
            return this.myCalculator.canCalculateFor(this.myLeftRevision, p);
        }
        catch (FilesTooBigForDiffException e) {
            return false;
        }
    }

    @Override
    protected boolean isRightContentAvailable(RevisionProcessingProgress p) {
        try {
            return this.myCalculator.canCalculateFor(this.myRightRevision, p);
        }
        catch (FilesTooBigForDiffException e) {
            return false;
        }
    }

    @Override
    protected DiffContent doGetLeftDiffContent(RevisionProcessingProgress p) {
        return this.getDiffContent(this.myLeftRevision, p);
    }

    @Override
    protected DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress p) {
        return this.getDiffContent(this.myRightRevision, p);
    }

    @Override
    protected DiffContent getEditableRightDiffContent(RevisionProcessingProgress p) {
        Document d = this.getDocument();
        int fromOffset = d.getLineStartOffset(this.myFrom);
        int toOffset = d.getLineEndOffset(this.myTo);
        DocumentContent documentContent = DiffContentFactory.getInstance().create(this.myProject, d);
        return new DocumentFragmentContent(this.myProject, documentContent, new TextRange(fromOffset, toOffset));
    }

    private DocumentContent getDiffContent(Revision r, RevisionProcessingProgress p) {
        return this.createSimpleDiffContent(this.getContentOf(r, p), r.findEntry());
    }

    private String getContentOf(Revision r, RevisionProcessingProgress p) {
        try {
            return this.myCalculator.getSelectionFor(r, p).getBlockContent();
        }
        catch (FilesTooBigForDiffException e) {
            return "";
        }
    }
}

