/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.actions;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.actions.ShowHistoryAction;
import com.intellij.history.integration.ui.views.SelectionHistoryDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import org.jetbrains.annotations.Nullable;

public class ShowSelectionHistoryAction
extends ShowHistoryAction {
    @Override
    protected void showDialog(Project p, IdeaGateway gw, VirtualFile f, AnActionEvent e) {
        VcsSelection sel = ShowSelectionHistoryAction.getSelection(e);
        int from = sel.getSelectionStartLineNumber();
        int to = sel.getSelectionEndLineNumber();
        new SelectionHistoryDialog(p, gw, f, from, to).show();
    }

    @Override
    protected String getText(AnActionEvent e) {
        VcsSelection sel = ShowSelectionHistoryAction.getSelection(e);
        return sel == null ? super.getText(e) : sel.getActionName();
    }

    @Override
    public void update(AnActionEvent e) {
        if (e.getData(CommonDataKeys.EDITOR) == null) {
            e.getPresentation().setVisible(false);
        } else {
            super.update(e);
        }
    }

    @Override
    protected boolean isEnabled(LocalHistoryFacade vcs, IdeaGateway gw, VirtualFile f, AnActionEvent e) {
        return super.isEnabled(vcs, gw, f, e) && !f.isDirectory() && ShowSelectionHistoryAction.getSelection(e) != null;
    }

    @Nullable
    private static VcsSelection getSelection(AnActionEvent e) {
        VcsContext c = VcsContextWrapper.createCachedInstanceOn(e);
        return VcsSelectionUtil.getSelection((VcsContext)c);
    }
}

