/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library;

import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DownloadableLibraryType
extends LibraryType<LibraryVersionProperties> {
    protected final Icon myIcon;
    private final String myLibraryCategoryName;
    private final DownloadableLibraryDescription myLibraryDescription;

    public DownloadableLibraryType(@NotNull String libraryCategoryName, @NotNull String libraryTypeId, @NotNull String groupId, @NotNull Icon icon, URL ... localUrls) {
        super(new PersistentLibraryKind<LibraryVersionProperties>(libraryTypeId){

            @NotNull
            public LibraryVersionProperties createDefaultProperties() {
                return new LibraryVersionProperties();
            }
        });
        this.myLibraryCategoryName = libraryCategoryName;
        this.myLibraryDescription = DownloadableLibraryService.getInstance().createLibraryDescription(groupId, localUrls);
        this.myIcon = icon;
    }

    @Nullable
    private static LibraryVersionProperties detectVersion(List<VirtualFile> classesRoots, String detectionClass) {
        if (!LibraryUtil.isClassAvailableInLibrary(classesRoots, (String)detectionClass)) {
            return null;
        }
        String version = JarVersionDetectionUtil.detectJarVersion((String)detectionClass, classesRoots);
        return new LibraryVersionProperties(version);
    }

    @Override
    public String getCreateActionName() {
        return null;
    }

    @Override
    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project2) {
        return null;
    }

    @NotNull
    public DownloadableLibraryDescription getLibraryDescription() {
        return this.myLibraryDescription;
    }

    public String getLibraryCategoryName() {
        return this.myLibraryCategoryName;
    }

    @Override
    public String getDescription(@NotNull LibraryVersionProperties properties) {
        String versionString = properties.getVersionString();
        return StringUtil.capitalize((String)this.myLibraryCategoryName) + " library" + (versionString != null ? " of version " + versionString : "");
    }

    @Override
    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<LibraryVersionProperties> editorComponent) {
        return DownloadableLibraryService.getInstance().createDownloadableLibraryEditor(this.myLibraryDescription, editorComponent, this);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    protected abstract String[] getDetectionClassNames();

    @Override
    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        for (String className : this.getDetectionClassNames()) {
            LibraryVersionProperties versionProperties = DownloadableLibraryType.detectVersion(classesRoots, className);
            if (versionProperties == null) continue;
            return versionProperties;
        }
        return null;
    }
}

