/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.framework.detection.impl.exclude.DetectionExcludesConfigurationImpl;
import com.intellij.framework.detection.impl.exclude.ExcludeListItem;
import com.intellij.framework.detection.impl.exclude.ExcludedFileState;
import com.intellij.framework.detection.impl.exclude.ExcludesConfigurationState;
import com.intellij.framework.detection.impl.exclude.InvalidExcludeListItem;
import com.intellij.framework.detection.impl.exclude.ValidExcludeListItem;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectionExcludesConfigurable
implements Configurable {
    private final Project myProject;
    private final DetectionExcludesConfigurationImpl myConfiguration;
    private final SortedListModel<ExcludeListItem> myModel;
    private JPanel myMainPanel;
    private JCheckBox myEnabledDetectionCheckBox;

    public DetectionExcludesConfigurable(@NotNull Project project2, @NotNull DetectionExcludesConfigurationImpl configuration) {
        this.myProject = project2;
        this.myConfiguration = configuration;
        this.myModel = new SortedListModel(ExcludeListItem.COMPARATOR);
    }

    @Nls
    @NotNull
    public JComponent createComponent() {
        this.myEnabledDetectionCheckBox = new JCheckBox("Enable framework detection");
        this.myEnabledDetectionCheckBox.setBorder(new EmptyBorder(10, 10, 0, 0));
        JBList excludesList = new JBList(this.myModel);
        ColoredListCellRenderer renderer = new ColoredListCellRenderer(){
            JPanel panel = new JPanel(new BorderLayout());
            {
                this.panel.setBorder(new EmptyBorder(2, 10, 2, 0));
                this.panel.add((Component)((Object)this));
            }

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setIconTextGap(4);
                if (value instanceof ExcludeListItem) {
                    ((ExcludeListItem)value).renderItem(this);
                    this.setBorder(new EmptyBorder(0, 10, 0, 0));
                }
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                super.getListCellRendererComponent(list, value, index, selected, hasFocus);
                this.panel.setBackground(UIUtil.getListBackground((boolean)selected));
                return this.panel;
            }
        };
        renderer.setMyBorder((Border)new EmptyBorder(0, 0, 0, 0));
        excludesList.setCellRenderer((ListCellRenderer)renderer);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)excludesList).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DetectionExcludesConfigurable.this.doAddAction(button);
            }
        });
        decorator.setPanelBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        this.myMainPanel = new JPanel(new BorderLayout(0, 5));
        this.myMainPanel.add((Component)this.myEnabledDetectionCheckBox, "North");
        final LabeledComponent excludesComponent = LabeledComponent.create((JComponent)decorator.createPanel(), (String)"   Exclude from detection:");
        this.myMainPanel.add((Component)excludesComponent);
        this.myEnabledDetectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtils.enableChildren((boolean)DetectionExcludesConfigurable.this.myEnabledDetectionCheckBox.isSelected(), (Component[])new Component[]{excludesComponent});
            }
        });
        this.myEnabledDetectionCheckBox.setSelected(true);
        return this.myMainPanel;
    }

    private void doAddAction(AnActionButton button) {
        ArrayList<FrameworkType> types = new ArrayList<FrameworkType>();
        for (FrameworkType frameworkType : FrameworkDetectorRegistry.getInstance().getFrameworkTypes()) {
            if (this.isExcluded(frameworkType)) continue;
            types.add(frameworkType);
        }
        Collections.sort(types, new Comparator<FrameworkType>(){

            @Override
            public int compare(FrameworkType o1, FrameworkType o2) {
                return o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName());
            }
        });
        types.add(0, null);
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<FrameworkType>("Framework to Exclude", types){

            public Icon getIconFor(FrameworkType value) {
                return value != null ? value.getIcon() : null;
            }

            @NotNull
            public String getTextFor(FrameworkType value) {
                return value != null ? value.getPresentableName() : "All Frameworks...";
            }

            public boolean hasSubstep(FrameworkType selectedValue) {
                return selectedValue != null;
            }

            public PopupStep onChosen(FrameworkType frameworkType, boolean finalChoice) {
                if (frameworkType == null) {
                    return this.doFinalStep(new Runnable(){

                        @Override
                        public void run() {
                            DetectionExcludesConfigurable.this.chooseDirectoryAndAdd(null);
                        }
                    });
                }
                return DetectionExcludesConfigurable.this.addExcludedFramework(frameworkType);
            }
        });
        RelativePoint relativePoint = button.getPreferredPopupPoint();
        if (relativePoint != null) {
            popup.show(relativePoint);
        } else {
            popup.showInCenterOf((Component)this.myMainPanel);
        }
    }

    private boolean isExcluded(@NotNull FrameworkType type) {
        for (ExcludeListItem item : this.myModel.getItems()) {
            if (!type.getId().equals(item.getFrameworkTypeId()) || item.getFileUrl() != null) continue;
            return true;
        }
        return false;
    }

    private PopupStep addExcludedFramework(final @NotNull FrameworkType frameworkType) {
        String projectItem = "In the whole project";
        return new BaseListPopupStep<String>(null, new String[]{"In the whole project", "In directory..."}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (selectedValue.equals("In the whole project")) {
                    DetectionExcludesConfigurable.this.addAndRemoveDuplicates(frameworkType, null);
                    return FINAL_CHOICE;
                }
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        DetectionExcludesConfigurable.this.chooseDirectoryAndAdd(frameworkType);
                    }
                });
            }
        };
    }

    private void addAndRemoveDuplicates(@Nullable FrameworkType frameworkType, @Nullable VirtualFile file2) {
        Iterator iterator = this.myModel.iterator();
        boolean add = true;
        while (iterator.hasNext()) {
            ExcludeListItem item = (ExcludeListItem)iterator.next();
            String fileUrl = item.getFileUrl();
            VirtualFile itemFile = fileUrl != null ? VirtualFileManager.getInstance().findFileByUrl(fileUrl) : null;
            String itemTypeId = item.getFrameworkTypeId();
            if (file2 == null) {
                if (frameworkType == null || !frameworkType.getId().equals(itemTypeId)) continue;
                iterator.remove();
                continue;
            }
            if (itemFile == null) continue;
            if (VfsUtil.isAncestor((VirtualFile)file2, (VirtualFile)itemFile, (boolean)false) && (frameworkType == null || frameworkType.getId().equals(itemTypeId))) {
                iterator.remove();
            }
            if (!VfsUtil.isAncestor((VirtualFile)itemFile, (VirtualFile)file2, (boolean)false) || itemTypeId != null && (frameworkType == null || !itemTypeId.equals(frameworkType.getId()))) continue;
            add = false;
        }
        if (add) {
            this.myModel.add((Object)new ValidExcludeListItem(frameworkType, file2));
        }
    }

    private void chooseDirectoryAndAdd(@Nullable FrameworkType type) {
        VirtualFile file2;
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setDescription((type != null ? type.getPresentableName() + " framework detection" : "Detection for all frameworks") + " will be disabled in selected directory");
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Component)this.myMainPanel, (Project)this.myProject, (VirtualFile)this.myProject.getBaseDir());
        VirtualFile virtualFile = file2 = files.length > 0 ? files[0] : null;
        if (file2 != null) {
            this.addAndRemoveDuplicates(type, file2);
        }
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.computeState(), (Object)this.myConfiguration.getActualState());
    }

    public void apply() {
        this.myConfiguration.loadState(this.computeState());
    }

    @Nullable
    private ExcludesConfigurationState computeState() {
        ExcludesConfigurationState state = new ExcludesConfigurationState();
        state.setDetectionEnabled(this.myEnabledDetectionCheckBox.isSelected());
        for (ExcludeListItem item : this.myModel.getItems()) {
            String url = item.getFileUrl();
            String typeId = item.getFrameworkTypeId();
            if (url == null) {
                state.getFrameworkTypes().add(typeId);
                continue;
            }
            state.getFiles().add(new ExcludedFileState(url, typeId));
        }
        return state;
    }

    public void reset() {
        this.myModel.clear();
        ExcludesConfigurationState state = this.myConfiguration.getActualState();
        this.myEnabledDetectionCheckBox.setSelected(state.isDetectionEnabled());
        for (String typeId : state.getFrameworkTypes()) {
            FrameworkType frameworkType = FrameworkDetectorRegistry.getInstance().findFrameworkType(typeId);
            this.myModel.add((Object)(frameworkType != null ? new ValidExcludeListItem(frameworkType, null) : new InvalidExcludeListItem(typeId, null)));
        }
        for (ExcludedFileState fileState : state.getFiles()) {
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(fileState.getUrl());
            String typeId = fileState.getFrameworkType();
            if (typeId == null) {
                this.myModel.add((Object)(file2 != null ? new ValidExcludeListItem(null, file2) : new InvalidExcludeListItem(null, fileState.getUrl())));
                continue;
            }
            FrameworkType frameworkType = FrameworkDetectorRegistry.getInstance().findFrameworkType(typeId);
            this.myModel.add((Object)(frameworkType != null && file2 != null ? new ValidExcludeListItem(frameworkType, file2) : new InvalidExcludeListItem(typeId, fileState.getUrl())));
        }
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Framework Detection Excludes";
    }

    public String getHelpTopic() {
        return null;
    }
}

