/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProbablyIncreasingLowerboundAlgorithm<T extends AbstractBlockWrapper> {
    private List<T> myBlocks;
    private int myLastCalculatedOffset = -1;
    private int myLastCalculatedAnswerIndex = -1;

    public ProbablyIncreasingLowerboundAlgorithm(@NotNull List<T> blocks) {
        this.myBlocks = blocks;
    }

    public void reset() {
        this.myLastCalculatedAnswerIndex = -1;
        this.myLastCalculatedOffset = -1;
    }

    public List<T> getLeftSubList(@Nullable AbstractBlockWrapper block) {
        return this.myBlocks.subList(0, this.getLeftRespNeighborIndex(block) + 1);
    }

    public void setBlocksList(List<T> blocks) {
        this.myBlocks = blocks;
        this.reset();
    }

    @Nullable
    public AbstractBlockWrapper getLeftRespNeighbor(@NotNull AbstractBlockWrapper block) {
        int index = this.getLeftRespNeighborIndex(block);
        if (index == -1) {
            return null;
        }
        return (AbstractBlockWrapper)this.myBlocks.get(index);
    }

    private int getLeftRespNeighborIndex(@Nullable AbstractBlockWrapper block) {
        if (block == null) {
            return this.myBlocks.size() - 1;
        }
        int offset = block.getStartOffset();
        if (this.myLastCalculatedOffset != -1) {
            if (offset >= this.myLastCalculatedOffset) {
                this.myLastCalculatedAnswerIndex = this.calcLeftRespNeighborIndexLinear(this.myLastCalculatedAnswerIndex, offset);
                this.myLastCalculatedOffset = offset;
                return this.myLastCalculatedAnswerIndex;
            }
            this.myLastCalculatedOffset = -1;
        }
        this.myLastCalculatedOffset = offset;
        this.myLastCalculatedAnswerIndex = this.calcLeftRespNeighborIndex(offset);
        return this.myLastCalculatedAnswerIndex;
    }

    private int calcLeftRespNeighborIndexLinear(int lastAnswerIndex, int blockOffset) {
        int index = lastAnswerIndex;
        while (index + 1 < this.myBlocks.size() && blockOffset > ((AbstractBlockWrapper)this.myBlocks.get(index + 1)).getStartOffset()) {
            ++index;
        }
        return index;
    }

    private int calcLeftRespNeighborIndex(int blockOffset) {
        int l = -1;
        int r = this.myBlocks.size();
        while (r - l > 1) {
            int m = (l + r) / 2;
            if (((AbstractBlockWrapper)this.myBlocks.get(m)).getStartOffset() >= blockOffset) {
                r = m;
                continue;
            }
            l = m;
        }
        return l;
    }
}

