/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndentInside {
    public int whiteSpaces = 0;
    public int tabs = 0;

    public IndentInside() {
    }

    public IndentInside(int whiteSpaces, int tabs) {
        this.whiteSpaces = whiteSpaces;
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentInside indent = (IndentInside)o;
        if (this.tabs != indent.tabs) {
            return false;
        }
        return this.whiteSpaces == indent.whiteSpaces;
    }

    public int hashCode() {
        int result = this.whiteSpaces;
        result = 29 * result + this.tabs;
        return result;
    }

    public int getTabsCount(CommonCodeStyleSettings.IndentOptions options) {
        int tabsFromSpaces = this.whiteSpaces / options.TAB_SIZE;
        return this.tabs + tabsFromSpaces;
    }

    public int getSpacesCount(CommonCodeStyleSettings.IndentOptions options) {
        return this.whiteSpaces + this.tabs * options.TAB_SIZE;
    }

    @NotNull
    static IndentInside getLastLineIndent(@NotNull CharSequence text) {
        CharSequence lastLine = IndentInside.getLastLine(text);
        return IndentInside.createIndentOn(lastLine);
    }

    @NotNull
    static IndentInside createIndentOn(@Nullable CharSequence lastLine) {
        IndentInside result = new IndentInside();
        if (lastLine == null) {
            return result;
        }
        for (int i = 0; i < lastLine.length(); ++i) {
            if (lastLine.charAt(i) == ' ') {
                ++result.whiteSpaces;
            }
            if (lastLine.charAt(i) != '\t') continue;
            ++result.tabs;
        }
        return result;
    }

    @NotNull
    static CharSequence getLastLine(@NotNull CharSequence text) {
        int i = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)(text.length() - 1), (String)"\n");
        if (i < 0) {
            return text;
        }
        if (i >= text.length() - 1) {
            return "";
        }
        return text.subSequence(i + 1, text.length());
    }

    public String toString() {
        return String.format("spaces: %d, tabs: %d", this.whiteSpaces, this.tabs);
    }
}

