/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapImpl;
import java.util.List;
import org.jdom.Element;

public class FormatInfoPrinter {
    private final Block myRootBlock;
    private final FormattingDocumentModel myDocumentModel;

    public FormatInfoPrinter(Block rootBlock, FormattingDocumentModel documentModel) {
        this.myRootBlock = rootBlock;
        this.myDocumentModel = documentModel;
    }

    public Element blocksAsTree() {
        return this.createBlockElement(this.myRootBlock);
    }

    private Element createBlockElement(Block block) {
        AlignmentImpl alignment;
        Indent indent;
        Wrap wrap;
        Element result = new Element("Block");
        this.printSimpleBlock(block, result);
        result.setAttribute("class", block.getClass().getName());
        if (block.getSubBlocks().size() == 0) {
            result.setAttribute("text", this.myDocumentModel.getText(block.getTextRange()).toString());
        }
        if ((wrap = block.getWrap()) != null) {
            Element wrapElem = new Element("Wrap");
            result.addContent(wrapElem);
            WrapImpl wrapImpl = (WrapImpl)wrap;
            wrapElem.setAttribute("id", wrapImpl.getId());
            wrapElem.setAttribute("type", wrapImpl.getType().name());
            wrapElem.setAttribute("ignoreParents", String.valueOf(wrapImpl.getIgnoreParentWraps()));
            wrapElem.setAttribute("wrapFirst", String.valueOf(wrapImpl.isWrapFirstElement()));
            WrapImpl parent = wrapImpl.getParent();
            if (parent != null) {
                wrapElem.setAttribute("parent", parent.getId());
            }
        }
        if ((indent = block.getIndent()) != null) {
            Element indentElement = new Element("Indent");
            result.addContent(indentElement);
            indentElement.setAttribute("type", ((IndentImpl)indent).getType().toString());
        }
        if ((alignment = (AlignmentImpl)block.getAlignment()) != null) {
            Element alEl = new Element("Alignment");
            result.addContent(alEl);
            alEl.setAttribute("id", alignment.getId());
        }
        List subBlocks = block.getSubBlocks();
        for (int i = 0; i < subBlocks.size(); ++i) {
            Spacing spacing;
            if (i > 0 && i < subBlocks.size() - 1 && (spacing = block.getSpacing((Block)subBlocks.get(i), (Block)subBlocks.get(i + 1))) != null) {
                result.addContent(this.createSpacingElement(spacing));
            }
            result.addContent(this.createBlockElement((Block)subBlocks.get(i)));
        }
        return result;
    }

    private Element createSpacingElement(Spacing spacing) {
        Element result = new Element("Spacing");
        SpacingImpl impl = (SpacingImpl)spacing;
        result.setAttribute("keepBlankLines", String.valueOf(impl.getKeepBlankLines()));
        result.setAttribute("keepLineBreaks", String.valueOf(impl.shouldKeepLineFeeds()));
        result.setAttribute("minspaces", String.valueOf(impl.getMinSpaces()));
        result.setAttribute("maxspaces", String.valueOf(impl.getMaxSpaces()));
        result.setAttribute("minlinefeeds", String.valueOf(impl.getMinLineFeeds()));
        result.setAttribute("readOnly", String.valueOf(impl.isReadOnly()));
        result.setAttribute("safe", String.valueOf(impl.isSafe()));
        return result;
    }

    private void printSimpleBlock(Block block, Element element) {
        element.setAttribute("start", String.valueOf(block.getTextRange().getStartOffset()));
        element.setAttribute("end", String.valueOf(block.getTextRange().getEndOffset()));
    }
}

