/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.SpacingImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DependantSpacingImpl
extends SpacingImpl {
    private static final int DEPENDENCE_CONTAINS_LF_MASK = 16;
    private static final int DEPENDENT_REGION_LF_CHANGED_MASK = 32;
    @NotNull
    private final List<TextRange> myDependentRegionRanges;
    @NotNull
    private final DependentSpacingRule myRule;

    public DependantSpacingImpl(int minSpaces, int maxSpaces, @NotNull TextRange dependency, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myDependentRegionRanges = ContainerUtil.newSmartList((Object)dependency);
        this.myRule = rule;
    }

    public DependantSpacingImpl(int minSpaces, int maxSpaces, @NotNull List<TextRange> dependencyRanges, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myDependentRegionRanges = dependencyRanges;
        this.myRule = rule;
    }

    @Override
    public int getMinLineFeeds() {
        if (!this.isTriggered()) {
            return super.getMinLineFeeds();
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS);
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS);
        }
        return super.getMinLineFeeds();
    }

    @Override
    public int getKeepBlankLines() {
        if (!this.isTriggered() || !this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return super.getKeepBlankLines();
        }
        return 0;
    }

    @Override
    public void refresh(FormatProcessor formatter) {
        if (this.isDependentRegionLinefeedStatusChanged()) {
            return;
        }
        boolean atLeastOneDependencyRangeContainsLf = false;
        for (TextRange dependency : this.myDependentRegionRanges) {
            atLeastOneDependencyRangeContainsLf |= formatter.containsLineFeeds(dependency);
        }
        this.myFlags = atLeastOneDependencyRangeContainsLf ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @NotNull
    public List<TextRange> getDependentRegionRanges() {
        return this.myDependentRegionRanges;
    }

    public final boolean isDependentRegionLinefeedStatusChanged() {
        return (this.myFlags & 0x20) != 0;
    }

    public final void setDependentRegionLinefeedStatusChanged() {
        this.myFlags |= 0x20;
        this.myFlags = this.getMinLineFeeds() <= 0 ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @Override
    public String toString() {
        String dependencies = StringUtil.join(this.myDependentRegionRanges, (Function)StringUtil.createToStringFunction(TextRange.class), (String)", ");
        return "<DependantSpacing: minSpaces=" + this.getMinSpaces() + " maxSpaces=" + this.getMaxSpaces() + " minLineFeeds=" + this.getMinLineFeeds() + " dep=" + dependencies + ">";
    }

    private boolean isTriggered() {
        return this.myRule.getTrigger() == DependentSpacingRule.Trigger.HAS_LINE_FEEDS ^ (this.myFlags & 0x10) == 0;
    }
}

