/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class DelegatingFormattingModel
implements FormattingModelEx {
    private final FormattingModel myBaseModel;
    private final Block myRootBlock;

    public DelegatingFormattingModel(FormattingModel model, Block block) {
        this.myBaseModel = model;
        this.myRootBlock = block;
    }

    @NotNull
    public Block getRootBlock() {
        return this.myRootBlock;
    }

    @NotNull
    public FormattingDocumentModel getDocumentModel() {
        return this.myBaseModel.getDocumentModel();
    }

    public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
        return this.myBaseModel.replaceWhiteSpace(textRange, whiteSpace);
    }

    public TextRange replaceWhiteSpace(TextRange textRange, ASTNode nodeAfter, String whiteSpace) {
        if (this.myBaseModel instanceof FormattingModelEx) {
            return ((FormattingModelEx)this.myBaseModel).replaceWhiteSpace(textRange, nodeAfter, whiteSpace);
        }
        return this.myBaseModel.replaceWhiteSpace(textRange, whiteSpace);
    }

    public TextRange shiftIndentInsideRange(ASTNode node, TextRange range, int indent) {
        return this.myBaseModel.shiftIndentInsideRange(node, range, indent);
    }

    public void commitChanges() {
        this.myBaseModel.commitChanges();
    }
}

