/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class JavaMethodFindUsagesOptions
extends JavaFindUsagesOptions {
    public boolean isOverridingMethods = false;
    public boolean isImplementingMethods = false;
    public boolean isCheckDeepInheritance = true;
    public boolean isIncludeInherited = false;
    public boolean isIncludeOverloadUsages = false;

    public JavaMethodFindUsagesOptions(@NotNull Project project2) {
        super(project2);
        this.isSearchForTextOccurrences = false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodFindUsagesOptions that = (JavaMethodFindUsagesOptions)o;
        if (this.isCheckDeepInheritance != that.isCheckDeepInheritance) {
            return false;
        }
        if (this.isImplementingMethods != that.isImplementingMethods) {
            return false;
        }
        if (this.isIncludeInherited != that.isIncludeInherited) {
            return false;
        }
        if (this.isIncludeOverloadUsages != that.isIncludeOverloadUsages) {
            return false;
        }
        return this.isOverridingMethods == that.isOverridingMethods;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isOverridingMethods ? 1 : 0);
        result = 31 * result + (this.isImplementingMethods ? 1 : 0);
        result = 31 * result + (this.isCheckDeepInheritance ? 1 : 0);
        result = 31 * result + (this.isIncludeInherited ? 1 : 0);
        result = 31 * result + (this.isIncludeOverloadUsages ? 1 : 0);
        return result;
    }

    @Override
    protected void addUsageTypes(@NotNull LinkedHashSet<String> strings) {
        super.addUsageTypes(strings);
        if (this.isIncludeOverloadUsages) {
            strings.add(FindBundle.message("find.usages.panel.title.overloaded.methods.usages", new Object[0]));
        }
        if (this.isImplementingMethods) {
            strings.add(FindBundle.message("find.usages.panel.title.implementing.methods", new Object[0]));
        }
        if (this.isOverridingMethods) {
            strings.add(FindBundle.message("find.usages.panel.title.overriding.methods", new Object[0]));
        }
    }
}

