/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
implements Cloneable {
    @NotNull
    public SearchScope searchScope;
    public boolean isSearchForTextOccurrences = true;
    public boolean isUsages = false;
    public SearchRequestCollector fastTrack = null;

    public FindUsagesOptions(@NotNull Project project2) {
        this(project2, null);
    }

    public FindUsagesOptions(@NotNull Project project2, @Nullable DataContext dataContext) {
        String defaultScopeName = FindSettings.getInstance().getDefaultScopeName();
        List<SearchScope> predefined = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project2, dataContext, true, false, false, false);
        GlobalSearchScope resultScope = null;
        for (SearchScope scope : predefined) {
            if (!scope.getDisplayName().equals(defaultScopeName)) continue;
            resultScope = scope;
            break;
        }
        if (resultScope == null) {
            resultScope = ProjectScope.getProjectScope((Project)project2);
        }
        this.searchScope = resultScope;
    }

    public FindUsagesOptions(@NotNull SearchScope searchScope) {
        this.searchScope = searchScope;
    }

    public FindUsagesOptions clone() {
        try {
            return (FindUsagesOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isSearchForTextOccurrences != that.isSearchForTextOccurrences) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        return this.searchScope.equals(that.searchScope);
    }

    public int hashCode() {
        int result = this.searchScope.hashCode();
        result = 31 * result + (this.isSearchForTextOccurrences ? 1 : 0);
        result = 31 * result + (this.isUsages ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "searchScope=" + this.searchScope + ", isSearchForTextOccurrences=" + this.isSearchForTextOccurrences + ", isUsages=" + this.isUsages + '}';
    }

    @NotNull
    public String generateUsagesString() {
        return "Usages";
    }
}

