/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.findUsages.PsiElement2UsageTargetComposite;
import com.intellij.find.findUsages.UsageHistory;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findParameterUsages.FindUsagesManager");
    private static final Key<String> KEY_START_USAGE_AGAIN = Key.create((String)"KEY_START_USAGE_AGAIN");
    @NonNls
    private static final String VALUE_START_USAGE_AGAIN = "START_AGAIN";
    private final Project myProject;
    private final UsageViewManager myAnotherManager;
    private PsiElement2UsageTargetComposite myLastSearchInFileData;
    private final UsageHistory myHistory = new UsageHistory();

    public FindUsagesManager(@NotNull Project project2, @NotNull UsageViewManager anotherManager) {
        this.myProject = project2;
        this.myAnotherManager = anotherManager;
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            try {
                if (!factory.canFindUsages(element)) continue;
                return true;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    public void clearFindingNextUsageInFile() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = null;
    }

    public boolean findNextUsageInFile(@NotNull FileEditor editor) {
        return this.findUsageInFile(editor, FileSearchScope.AFTER_CARET);
    }

    public boolean findPreviousUsageInFile(@NotNull FileEditor editor) {
        return this.findUsageInFile(editor, FileSearchScope.BEFORE_CARET);
    }

    private boolean findUsageInFile(@NotNull FileEditor editor, @NotNull FileSearchScope direction) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLastSearchInFileData == null) {
            return false;
        }
        PsiElement[] primaryElements = this.myLastSearchInFileData.getPrimaryElements();
        PsiElement[] secondaryElements = this.myLastSearchInFileData.getSecondaryElements();
        if (primaryElements.length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.searched.elements.have.been.changed.error", new Object[0]), (String)FindBundle.message("cannot.search.for.usages.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return false;
        }
        TextEditor textEditor = (TextEditor)editor;
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FindUsagesHandler handler2 = this.getFindUsagesHandler(primaryElements[0], false);
        if (handler2 == null) {
            return false;
        }
        this.findUsagesInEditor(primaryElements, secondaryElements, handler2, psiFile, direction, this.myLastSearchInFileData.myOptions, (FileEditor)textEditor);
        return true;
    }

    private void initLastSearchElement(@NotNull FindUsagesOptions findUsagesOptions, @NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = new PsiElement2UsageTargetComposite(primaryElements, secondaryElements, findUsagesOptions);
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            FindUsagesHandler handler2 = factory.createFindUsagesHandler(element, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    public FindUsagesHandler getNewFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            Class<?> aClass = factory.getClass();
            FindUsagesHandlerFactory copy = (FindUsagesHandlerFactory)new ConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(this.myProject.getPicoContainer());
            FindUsagesHandler handler2 = copy.createFindUsagesHandler(element, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    public void findUsages(@NotNull PsiElement psiElement, PsiFile scopeFile, FileEditor editor, boolean showDialog, @Nullable(value="null means default (stored in options)") SearchScope searchScope) {
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, false);
        if (handler2 == null) {
            return;
        }
        boolean singleFile = scopeFile != null;
        AbstractFindUsagesDialog dialog = handler2.getFindUsagesDialog(singleFile, this.shouldOpenInNewTab(), this.mustOpenInNewTab());
        if (showDialog) {
            if (!dialog.showAndGet()) {
                return;
            }
        } else {
            dialog.close(0);
        }
        this.setOpenInNewTab(dialog.isShowInSeparateWindow());
        FindUsagesOptions findUsagesOptions = dialog.calcFindUsagesOptions();
        if (searchScope != null) {
            findUsagesOptions.searchScope = searchScope;
        }
        this.clearFindingNextUsageInFile();
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor);
    }

    void startFindUsages(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions findUsagesOptions, PsiFile scopeFile, FileEditor editor) {
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, false);
        if (handler2 == null) {
            return;
        }
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor);
    }

    private void startFindUsages(@NotNull FindUsagesOptions findUsagesOptions, @NotNull FindUsagesHandler handler2, PsiFile scopeFile, FileEditor editor) {
        boolean singleFile = scopeFile != null;
        this.clearFindingNextUsageInFile();
        LOG.assertTrue(handler2.getPsiElement().isValid());
        PsiElement[] primaryElements = handler2.getPrimaryElements();
        FindUsagesManager.checkNotNull(primaryElements, handler2, "getPrimaryElements()");
        PsiElement[] secondaryElements = handler2.getSecondaryElements();
        FindUsagesManager.checkNotNull(secondaryElements, handler2, "getSecondaryElements()");
        if (singleFile) {
            editor.putUserData(KEY_START_USAGE_AGAIN, null);
            this.findUsagesInEditor(primaryElements, secondaryElements, handler2, scopeFile, FileSearchScope.FROM_START, findUsagesOptions.clone(), editor);
        } else {
            boolean skipResultsWithOneUsage = FindSettings.getInstance().isSkipResultsWithOneUsage();
            this.findUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, skipResultsWithOneUsage);
        }
    }

    public static void showSettingsAndFindUsages(@NotNull NavigationItem[] targets) {
        if (targets.length == 0) {
            return;
        }
        NavigationItem target = targets[0];
        if (!(target instanceof ConfigurableUsageTarget)) {
            return;
        }
        ((ConfigurableUsageTarget)target).showSettings();
    }

    private static void checkNotNull(@NotNull PsiElement[] elements, @NotNull FindUsagesHandler handler2, @NonNls @NotNull String methodName) {
        for (PsiElement element : elements) {
            if (element != null) continue;
            LOG.error(handler2 + "." + methodName + " has returned array with null elements: " + Arrays.asList(elements));
        }
    }

    @NotNull
    public static ProgressIndicator startProcessUsages(final @NotNull FindUsagesHandler handler2, final @NotNull PsiElement[] primaryElements, final @NotNull PsiElement[] secondaryElements, final @NotNull Processor<Usage> processor2, final @NotNull FindUsagesOptions findUsagesOptions, final @NotNull Runnable onComplete) {
        final ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().runProcess(new Runnable(){

                        @Override
                        public void run() {
                            UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(primaryElements, secondaryElements, handler2, findUsagesOptions, null);
                            usageSearcher.generate(processor2);
                        }
                    }, (ProgressIndicator)indicator);
                }
                finally {
                    onComplete.run();
                }
            }
        });
        return indicator;
    }

    @NotNull
    public UsageViewPresentation createPresentation(@NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions) {
        PsiElement element = handler2.getPsiElement();
        LOG.assertTrue(element.isValid());
        return FindUsagesManager.createPresentation(element, findUsagesOptions, FindSettings.getInstance().isShowResultsInSeparateView());
    }

    private void setOpenInNewTab(boolean toOpenInNewTab) {
        if (!this.mustOpenInNewTab()) {
            FindSettings.getInstance().setShowResultsInSeparateView(toOpenInNewTab);
        }
    }

    private boolean shouldOpenInNewTab() {
        return this.mustOpenInNewTab() || FindSettings.getInstance().isShowResultsInSeparateView();
    }

    private boolean mustOpenInNewTab() {
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        return selectedContent != null && selectedContent.isPinned();
    }

    @NotNull
    private static UsageSearcher createUsageSearcher(final @NotNull PsiElement[] primaryElements, final @NotNull PsiElement[] secondaryElements, final @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions options, final PsiFile scopeFile) {
        final FindUsagesOptions optionsClone = options.clone();
        return new UsageSearcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(final @NotNull Processor<Usage> processor2) {
                Project project2 = (Project)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Project>(){

                    public Project compute() {
                        return scopeFile != null ? scopeFile.getProject() : primaryElements[0].getProject();
                    }
                });
                FindUsagesManager.dropResolveCacheRegularly(ProgressManager.getInstance().getProgressIndicator(), project2);
                if (scopeFile != null) {
                    optionsClone.searchScope = new LocalSearchScope((PsiElement)scopeFile);
                }
                CommonProcessors.UniqueProcessor usageInfoProcessor = new CommonProcessors.UniqueProcessor((Processor)new Processor<UsageInfo>(){

                    public boolean process(final UsageInfo usageInfo) {
                        Usage usage = (Usage)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Usage>(){

                            public Usage compute() {
                                return UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo)usageInfo);
                            }
                        });
                        return processor2.process((Object)usage);
                    }
                });
                Iterable elements = ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements});
                optionsClone.fastTrack = new SearchRequestCollector(new SearchSession());
                if (optionsClone.searchScope instanceof GlobalSearchScope) {
                    optionsClone.searchScope = optionsClone.searchScope.union((SearchScope)GlobalSearchScope.projectScope((Project)project2));
                }
                try {
                    for (final PsiElement element : elements) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                LOG.assertTrue(element.isValid());
                            }
                        });
                        handler2.processElementUsages(element, (Processor<UsageInfo>)usageInfoProcessor, optionsClone);
                        for (CustomUsageSearcher searcher : (CustomUsageSearcher[])Extensions.getExtensions(CustomUsageSearcher.EP_NAME)) {
                            try {
                                searcher.processElementUsages(element, processor2, optionsClone);
                            }
                            catch (IndexNotReadyException e) {
                                DumbService.getInstance((Project)element.getProject()).showDumbModeNotification("Find usages is not available during indexing");
                            }
                            catch (ProcessCanceledException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                    PsiSearchHelper.SERVICE.getInstance((Project)project2).processRequests(optionsClone.fastTrack, (Processor)new Processor<PsiReference>((Processor)usageInfoProcessor){
                        final /* synthetic */ Processor val$usageInfoProcessor;
                        {
                            this.val$usageInfoProcessor = processor2;
                        }

                        public boolean process(final PsiReference ref) {
                            UsageInfo info = (UsageInfo)ApplicationManager.getApplication().runReadAction((Computable)new Computable<UsageInfo>(){

                                public UsageInfo compute() {
                                    if (!ref.getElement().isValid()) {
                                        return null;
                                    }
                                    return new UsageInfo(ref);
                                }
                            });
                            return info == null || this.val$usageInfoProcessor.process((Object)info);
                        }
                    });
                }
                finally {
                    optionsClone.fastTrack = null;
                }
            }
        };
    }

    @NotNull
    private static PsiElement2UsageTargetAdapter[] convertToUsageTargets(@NotNull Iterable<PsiElement> elementsToSearch, final @NotNull FindUsagesOptions findUsagesOptions) {
        List targets = ContainerUtil.map(elementsToSearch, (Function)new Function<PsiElement, PsiElement2UsageTargetAdapter>(){

            public PsiElement2UsageTargetAdapter fun(PsiElement element) {
                return FindUsagesManager.convertToUsageTarget(element, findUsagesOptions);
            }
        });
        return targets.toArray(new PsiElement2UsageTargetAdapter[targets.size()]);
    }

    public void findUsages(final @NotNull PsiElement[] primaryElements, final @NotNull PsiElement[] secondaryElements, final @NotNull FindUsagesHandler handler2, final @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (primaryElements.length == 0) {
            throw new AssertionError((Object)(handler2 + " " + findUsagesOptions));
        }
        Iterable allElements = ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements});
        PsiElement2UsageTargetAdapter[] targets = FindUsagesManager.convertToUsageTargets(allElements, findUsagesOptions);
        this.myAnotherManager.searchAndShowUsages((UsageTarget[])targets, (Factory)new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return FindUsagesManager.createUsageSearcher(primaryElements, secondaryElements, handler2, findUsagesOptions, null);
            }
        }, !toSkipUsagePanelWhenOneUsage, true, FindUsagesManager.createPresentation(primaryElements[0], findUsagesOptions, this.shouldOpenInNewTab()), null);
        this.myHistory.add(targets[0]);
    }

    private static void dropResolveCacheRegularly(ProgressIndicator indicator, final @NotNull Project project2) {
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate(new ProgressIndicatorBase(){
                volatile long lastCleared = System.currentTimeMillis();

                @Override
                public void setFraction(double fraction) {
                    super.setFraction(fraction);
                    long current = System.currentTimeMillis();
                    if (current - this.lastCleared >= 500L) {
                        this.lastCleared = current;
                        PsiManager.getInstance((Project)project2).dropResolveCaches();
                    }
                }
            });
        }
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions options, boolean toOpenInNewTab) {
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scopeString = options.searchScope.getDisplayName();
        presentation.setScopeText(scopeString);
        String usagesString = FindUsagesManager.generateUsagesString(options);
        presentation.setUsagesString(usagesString);
        String title = FindBundle.message("find.usages.of.element.in.scope.panel.title", usagesString, UsageViewUtil.getLongName(psiElement), scopeString);
        presentation.setTabText(title);
        presentation.setTabName(FindBundle.message("find.usages.of.element.tab.name", usagesString, UsageViewUtil.getShortName(psiElement)));
        presentation.setTargetsNodeText(StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)));
        presentation.setOpenInNewTab(toOpenInNewTab);
        return presentation;
    }

    private void findUsagesInEditor(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesHandler handler2, @NotNull PsiFile scopeFile, @NotNull FileSearchScope direction, @NotNull FindUsagesOptions findUsagesOptions, @NotNull FileEditor fileEditor) {
        this.initLastSearchElement(findUsagesOptions, primaryElements, secondaryElements);
        this.clearStatusBar();
        FileEditorLocation currentLocation = fileEditor.getCurrentLocation();
        UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(primaryElements, secondaryElements, handler2, findUsagesOptions, scopeFile);
        AtomicBoolean usagesWereFound = new AtomicBoolean();
        Usage fUsage = FindUsagesManager.findSiblingUsage(usageSearcher, direction, currentLocation, usagesWereFound, fileEditor);
        if (fUsage != null) {
            fUsage.navigate(true);
            fUsage.selectInEditor();
        } else if (!usagesWereFound.get()) {
            String message = FindUsagesManager.getNoUsagesFoundMessage(primaryElements[0]) + " in " + scopeFile.getName();
            this.showHintOrStatusBarMessage(message, fileEditor);
        } else {
            fileEditor.putUserData(KEY_START_USAGE_AGAIN, (Object)VALUE_START_USAGE_AGAIN);
            this.showHintOrStatusBarMessage(FindUsagesManager.getSearchAgainMessage(primaryElements[0], direction), fileEditor);
        }
    }

    private static String getNoUsagesFoundMessage(PsiElement psiElement) {
        String elementType = UsageViewUtil.getType(psiElement);
        String elementName = UsageViewUtil.getShortName(psiElement);
        return FindBundle.message("find.usages.of.element_type.element_name.not.found.message", elementType, elementName);
    }

    private void clearStatusBar() {
        StatusBar.Info.set((String)"", (Project)this.myProject);
    }

    private static String getSearchAgainMessage(PsiElement element, FileSearchScope direction) {
        String shortcutsText;
        AnAction action;
        String shortcutsText2;
        String message = FindUsagesManager.getNoUsagesFoundMessage(element);
        message = direction == FileSearchScope.AFTER_CARET ? ((shortcutsText2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message("find.search.again.from.top.action.message", message) : FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText2)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FindPrevious"))).isEmpty() ? FindBundle.message("find.search.again.from.bottom.action.message", message) : FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText));
        return message;
    }

    private void showHintOrStatusBarMessage(String message, FileEditor fileEditor) {
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            FindUsagesManager.showEditorHint(message, textEditor.getEditor());
        } else {
            StatusBar.Info.set((String)message, (Project)this.myProject);
        }
    }

    private static Usage findSiblingUsage(@NotNull UsageSearcher usageSearcher, @NotNull FileSearchScope dir, final FileEditorLocation currentLocation, final @NotNull AtomicBoolean usagesWereFound, @NotNull FileEditor fileEditor) {
        if (fileEditor.getUserData(KEY_START_USAGE_AGAIN) != null) {
            dir = dir == FileSearchScope.AFTER_CARET ? FileSearchScope.FROM_START : FileSearchScope.FROM_END;
        }
        final FileSearchScope direction = dir;
        final AtomicReference foundUsage = new AtomicReference();
        usageSearcher.generate((Processor)new Processor<Usage>(){

            public boolean process(Usage usage) {
                block5: {
                    Usage found;
                    block6: {
                        block4: {
                            usagesWereFound.set(true);
                            if (direction == FileSearchScope.FROM_START) {
                                foundUsage.compareAndSet(null, usage);
                                return false;
                            }
                            if (direction != FileSearchScope.FROM_END) break block4;
                            foundUsage.set(usage);
                            break block5;
                        }
                        if (direction != FileSearchScope.AFTER_CARET) break block6;
                        if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) > 0) {
                            foundUsage.set(usage);
                            return false;
                        }
                        break block5;
                    }
                    if (direction != FileSearchScope.BEFORE_CARET) break block5;
                    if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) >= 0) {
                        return false;
                    }
                    while (!((found = (Usage)foundUsage.get()) == null ? foundUsage.compareAndSet(null, usage) : Comparing.compare((Comparable)found.getLocation(), (Comparable)usage.getLocation()) < 0 && foundUsage.compareAndSet(found, usage))) {
                    }
                }
                return true;
            }
        });
        fileEditor.putUserData(KEY_START_USAGE_AGAIN, null);
        return (Usage)foundUsage.get();
    }

    private static PsiElement2UsageTargetAdapter convertToUsageTarget(@NotNull PsiElement elementToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementToSearch instanceof NavigationItem) {
            return new PsiElement2UsageTargetAdapter(elementToSearch, findUsagesOptions);
        }
        throw new IllegalArgumentException("Wrong usage target:" + elementToSearch + "; " + elementToSearch.getClass());
    }

    @NotNull
    private static String generateUsagesString(@NotNull FindUsagesOptions selectedOptions) {
        return selectedOptions.generateUsagesString();
    }

    private static void showEditorHint(String message, Editor editor) {
        JComponent component = HintUtil.createInformationLabel(message);
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    public static String getHelpID(PsiElement element) {
        return ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(element.getLanguage())).getHelpId(element);
    }

    public void rerunAndRecallFromHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        usageTarget.findUsages();
        this.addToHistory(usageTarget);
    }

    public void addToHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        this.myHistory.add(usageTarget);
    }

    @NotNull
    public UsageHistory getHistory() {
        return this.myHistory;
    }

    @NotNull
    public static GlobalSearchScope getMaximalScope(@NotNull FindUsagesHandler handler2) {
        PsiElement element = handler2.getPsiElement();
        Project project2 = element.getProject();
        PsiFile file2 = element.getContainingFile();
        if (file2 != null && ProjectFileIndex.SERVICE.getInstance((Project)project2).isInContent(file2.getViewProvider().getVirtualFile())) {
            return GlobalSearchScope.projectScope((Project)project2);
        }
        return GlobalSearchScope.allScope((Project)project2);
    }

    private static enum FileSearchScope {
        FROM_START,
        FROM_END,
        AFTER_CARET,
        BEFORE_CARET;

    }
}

