/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindUsagesHandler {
    @NotNull
    public static final FindUsagesHandler NULL_HANDLER = new NullFindUsagesHandler();
    @NotNull
    private final PsiElement myPsiElement;

    protected FindUsagesHandler(@NotNull PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        return new CommonFindUsagesDialog(this.myPsiElement, this.getProject(), this.getFindUsagesOptions(DataManager.getInstance().getDataContext()), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
    }

    @NotNull
    public final PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @NotNull
    public final Project getProject() {
        return this.myPsiElement.getProject();
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        return new PsiElement[]{this.myPsiElement};
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    protected String getHelpId() {
        return FindUsagesManager.getHelpID(this.myPsiElement);
    }

    @NotNull
    public static FindUsagesOptions createFindUsagesOptions(@NotNull Project project2, @Nullable DataContext dataContext) {
        FindUsagesOptions findUsagesOptions = new FindUsagesOptions(project2, dataContext);
        findUsagesOptions.isUsages = true;
        findUsagesOptions.isSearchForTextOccurrences = true;
        return findUsagesOptions;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        return this.getFindUsagesOptions(null);
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        FindUsagesOptions options = FindUsagesHandler.createFindUsagesOptions(this.getProject(), dataContext);
        options.isSearchForTextOccurrences &= this.isSearchForTextOccurencesAvailable(this.getPsiElement(), false);
        return options;
    }

    public boolean processElementUsages(final @NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor2, @NotNull FindUsagesOptions options) {
        boolean success;
        boolean searchText;
        ReadActionProcessor<PsiReference> refProcessor = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                TextRange rangeInElement = ref.getRangeInElement();
                return processor2.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
            }
        };
        final SearchScope scope = options.searchScope;
        boolean bl = searchText = options.isSearchForTextOccurrences && scope instanceof GlobalSearchScope;
        if (options.isUsages && !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, scope, false, options.fastTrack)).forEach((Processor)refProcessor))) {
            return false;
        }
        if (searchText) {
            if (options.fastTrack != null) {
                options.fastTrack.searchCustom((Processor)new Processor<Processor<PsiReference>>(){

                    public boolean process(Processor<PsiReference> consumer) {
                        return FindUsagesHandler.this.processUsagesInText(element, (Processor<UsageInfo>)processor2, (GlobalSearchScope)scope);
                    }
                });
            } else {
                return this.processUsagesInText(element, processor2, (GlobalSearchScope)scope);
            }
        }
        return true;
    }

    public boolean processUsagesInText(final @NotNull PsiElement element, @NotNull Processor<UsageInfo> processor2, @NotNull GlobalSearchScope searchScope) {
        Collection stringToSearch = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<Collection<String>>(){

            public Collection<String> compute() {
                return FindUsagesHandler.this.getStringsToSearch(element);
            }
        });
        if (stringToSearch == null) {
            return true;
        }
        return FindUsagesHelper.processUsagesInText(element, stringToSearch, searchScope, processor2);
    }

    @Nullable
    protected Collection<String> getStringsToSearch(@NotNull PsiElement element) {
        if (element instanceof PsiNamedElement) {
            return ContainerUtil.createMaybeSingletonList((Object)((PsiNamedElement)element).getName());
        }
        return Collections.singleton(element.getText());
    }

    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        return false;
    }

    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        return ReferencesSearch.search((PsiElement)target, (SearchScope)searchScope, (boolean)false).findAll();
    }

    private static class NullFindUsagesHandler
    extends FindUsagesHandler {
        private NullFindUsagesHandler() {
            super(PsiUtilCore.NULL_PSI_ELEMENT);
        }

        @Override
        @NotNull
        public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public PsiElement[] getPrimaryElements() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public PsiElement[] getSecondaryElements() {
            throw new IncorrectOperationException();
        }

        @Override
        @Nullable
        protected String getHelpId() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public FindUsagesOptions getFindUsagesOptions() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor2, @NotNull FindUsagesOptions options) {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean processUsagesInText(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor2, @NotNull GlobalSearchScope searchScope) {
            throw new IncorrectOperationException();
        }

        @Override
        @Nullable
        protected Collection<String> getStringsToSearch(@NotNull PsiElement element) {
            throw new IncorrectOperationException();
        }

        @Override
        protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
            throw new IncorrectOperationException();
        }
    }
}

