/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.pointers.FacetPointersManagerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetPointerImpl<F extends Facet>
implements FacetPointer<F> {
    private final FacetPointersManagerImpl myManager;
    private String myModuleName;
    private String myFacetTypeId;
    private String myFacetName;
    private F myFacet;

    public FacetPointerImpl(FacetPointersManagerImpl manager, String id) {
        this.myManager = manager;
        int i = id.indexOf(47);
        this.myModuleName = id.substring(0, i);
        int j = id.lastIndexOf(47);
        this.myFacetTypeId = id.substring(i + 1, j);
        this.myFacetName = id.substring(j + 1);
    }

    public FacetPointerImpl(FacetPointersManagerImpl manager, @NotNull F facet) {
        this.myManager = manager;
        this.myFacet = facet;
        this.updateInfo(this.myFacet);
        this.registerDisposable();
    }

    public void refresh() {
        this.findAndSetFacet();
        if (this.myFacet != null) {
            this.updateInfo(this.myFacet);
        }
    }

    private void findAndSetFacet() {
        if (this.myFacet == null) {
            this.myFacet = this.findFacet();
            if (this.myFacet != null) {
                this.registerDisposable();
            }
        }
    }

    private void registerDisposable() {
        Disposer.register(this.myFacet, (Disposable)new Disposable(){

            public void dispose() {
                FacetPointerImpl.this.myManager.dispose(FacetPointerImpl.this);
                FacetPointerImpl.this.myFacet = null;
            }
        });
    }

    private void updateInfo(@NotNull F facet) {
        this.myModuleName = facet.getModule().getName();
        this.myFacetTypeId = facet.getType().getStringId();
        this.myFacetName = facet.getName();
    }

    @NotNull
    public Project getProject() {
        return this.myManager.getProject();
    }

    public F getFacet() {
        this.findAndSetFacet();
        return this.myFacet;
    }

    @Nullable
    private F findFacet() {
        Module module2 = ModuleManager.getInstance((Project)this.myManager.getProject()).findModuleByName(this.myModuleName);
        if (module2 == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)FacetManager.getInstance((Module)module2).findFacet(type.getId(), this.myFacetName);
    }

    @Nullable
    public F findFacet(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        Module module2 = modulesProvider.getModule(this.myModuleName);
        if (module2 == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)facetsProvider.findFacet(module2, type.getId(), this.myFacetName);
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public String getFacetName() {
        return this.myFacetName;
    }

    @NotNull
    public String getId() {
        return FacetPointersManager.constructId((String)this.myModuleName, (String)this.myFacetTypeId, (String)this.myFacetName);
    }

    @NotNull
    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    @NotNull
    public String getModuleName(@Nullable ModifiableModuleModel moduleModel) {
        String newName;
        if (moduleModel != null && this.myFacet != null && (newName = moduleModel.getNewName(this.myFacet.getModule())) != null) {
            return newName;
        }
        return this.myModuleName;
    }

    @NotNull
    public String getFacetName(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        if (this.myFacet != null) {
            return modulesProvider.getFacetModel(this.myFacet.getModule()).getFacetName(this.myFacet);
        }
        return this.myFacetName;
    }

    @Nullable
    public FacetType<F, ?> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetTypeId);
    }
}

